/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.i18n;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.i18n.InternationalizationService;
import org.wisdom.i18n.I18nExtension;

public final class ExtenderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternationalizationService.class);

    private ExtenderUtils() {
    }

    public static List<I18nExtension> analyze(String path, Bundle bundle) {
        ArrayList<I18nExtension> list = new ArrayList<I18nExtension>();
        Enumeration paths = bundle.getEntryPaths(path);
        if (paths != null) {
            while (paths.hasMoreElements()) {
                String entry = (String)paths.nextElement();
                if (entry.endsWith("/")) continue;
                String file = entry.substring(path.length() - 1);
                Locale locale = ExtenderUtils.getLocaleFromResourceName(file);
                URL url = bundle.getEntry(entry);
                if (url != null) {
                    I18nExtension extension = new I18nExtension(url, locale, bundle);
                    try {
                        extension.load();
                        list.add(extension);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot load resource bundle from " + path + " within " + bundle.getSymbolicName(), (Throwable)e);
                    }
                    continue;
                }
                LOGGER.error("Cannot open " + entry + " from " + bundle.getSymbolicName());
            }
        }
        return list;
    }

    public static Locale getLocaleFromResourceName(String name) {
        int index = name.indexOf(95);
        if (index != -1) {
            String locale = name.substring(index + 1);
            if (locale.lastIndexOf(46) != -1) {
                int lastDot = locale.lastIndexOf(46);
                locale = locale.substring(0, lastDot).replace("_", "-");
            }
            return Locale.forLanguageTag(locale);
        }
        return InternationalizationService.DEFAULT_LOCALE;
    }
}

