/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcrom.conf;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.configuration.Configuration;

public class JcromConfiguration {
    public static final String JCROM_PREFIX = "jcrom";
    public static final String PACKAGES_PREFIX = "packages";
    public static final String DYNAMIC_INSTANTIATION = "dynamic.instantiation";
    public static final String CLEAN_NAMES = "clean.names";
    public static final String REPOSITORY = "repository";
    public static final String CREATE_PATH = "create.path";
    private Configuration configuration;
    private String env;

    public JcromConfiguration(Configuration configuration, String env) {
        this.configuration = configuration;
        this.env = env;
    }

    public static JcromConfiguration fromApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        if (applicationConfiguration.has(JCROM_PREFIX)) {
            String env = null;
            if (applicationConfiguration.isDev()) {
                env = "dev";
            } else if (applicationConfiguration.isTest()) {
                env = "test";
            } else if (applicationConfiguration.isProd()) {
                env = "prod";
            }
            return new JcromConfiguration(applicationConfiguration.getConfiguration(JCROM_PREFIX), env);
        }
        return null;
    }

    public boolean isDynamicInstantiation() {
        return this.configuration.getBooleanWithDefault(DYNAMIC_INSTANTIATION, Boolean.valueOf(true));
    }

    public boolean isCreatePath() {
        return this.configuration.getBooleanWithDefault(CREATE_PATH, Boolean.valueOf(true));
    }

    public boolean isCleanNames() {
        return this.configuration.getBooleanWithDefault(CLEAN_NAMES, Boolean.valueOf(true));
    }

    public String getRepository() {
        return this.configuration.get(this.env + "." + REPOSITORY);
    }

    public List<String> getPackages() {
        return this.configuration.getList(PACKAGES_PREFIX);
    }

    public Dictionary<String, String> toDictionary() {
        Hashtable<String, String> dico = new Hashtable<String, String>(3);
        ((Dictionary)dico).put(DYNAMIC_INSTANTIATION, Boolean.toString(this.isDynamicInstantiation()));
        ((Dictionary)dico).put(CLEAN_NAMES, Boolean.toString(this.isCleanNames()));
        ((Dictionary)dico).put(PACKAGES_PREFIX, this.getPackages().stream().collect(Collectors.joining(",")));
        return dico;
    }
}

