/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcrom.runtime;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jcrom.Jcrom;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.model.Crud;
import org.wisdom.jcrom.object.JcrCrud;
import org.wisdom.jcrom.runtime.JcrCrudService;
import org.wisdom.jcrom.runtime.JcrRepository;
import org.wisdom.jcrom.runtime.JcromCrudProvider;

public class BundleCrudComponent {
    private Logger logger = LoggerFactory.getLogger(BundleCrudComponent.class);
    private JcrRepository repository;
    private Map<JcrCrud, ServiceRegistration> crudServiceRegistrations = new HashMap<JcrCrud, ServiceRegistration>();
    private Jcrom jcrom;

    public BundleCrudComponent(JcrRepository repository) {
        this.repository = repository;
    }

    public void addEntity(Bundle bundle, BundleContext context, URL entry) {
        try {
            this.logger.info("Enable mapping in jcrom for " + entry);
            String className = JcromCrudProvider.urlToClassName(entry);
            Class clazz = bundle.loadClass(className);
            this.createCrudService(this.repository, clazz, context);
        }
        catch (ClassNotFoundException e) {
            this.logger.debug(e.getMessage());
        }
        catch (RepositoryException e) {
            this.logger.debug(e.getMessage());
        }
        catch (NullPointerException e) {
            this.logger.debug(e.getMessage());
        }
    }

    protected void createCrudService(JcrRepository repository, Class entity, BundleContext bundleContext) throws RepositoryException {
        this.getJcrom().map(entity);
        JcrCrudService jcromCrudService = new JcrCrudService(repository, this.getJcrom(), entity);
        this.crudServiceRegistrations.put(jcromCrudService, this.registerCrud(repository, bundleContext, jcromCrudService));
        repository.addCrudService(jcromCrudService);
    }

    private Jcrom createJcrom() {
        return this.repository.createJcrom();
    }

    private Jcrom getJcrom() {
        if (this.jcrom == null) {
            this.jcrom = this.createJcrom();
        }
        return this.jcrom;
    }

    private ServiceRegistration registerCrud(JcrRepository repository, BundleContext context, JcrCrudService crud) {
        Dictionary<String, String> prop = repository.getJcromConfiguration().toDictionary();
        prop.put("entity.class", (String)((Object)crud.getEntityClass()));
        prop.put("entity.classname", crud.getEntityClass().getName());
        ServiceRegistration serviceRegistration = context.registerService(new String[]{Crud.class.getName(), JcrCrud.class.getName()}, (Object)crud, prop);
        return serviceRegistration;
    }

    public void remove() {
        for (Crud crud : this.crudServiceRegistrations.keySet()) {
            this.crudServiceRegistrations.get(crud).unregister();
            this.repository.removeCrudService(crud);
        }
        this.crudServiceRegistrations.clear();
    }
}

