/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcrom.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import org.jcrom.annotations.JcrNode;
import org.jcrom.dao.AbstractJcrDAO;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;
import org.jcrom.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.model.EntityFilter;
import org.wisdom.api.model.FluentTransaction;
import org.wisdom.api.model.Repository;
import org.wisdom.api.model.TransactionManager;
import org.wisdom.jcrom.object.JcrCrud;
import org.wisdom.jcrom.runtime.JcrQueryFactory;
import org.wisdom.jcrom.runtime.JcrRepository;
import org.wisdom.jcrom.runtime.JcrTools;

public class JcrCrudService<T>
implements JcrCrud<T, String> {
    private Logger logger = LoggerFactory.getLogger(JcrCrudService.class);
    protected final JcrRepository repository;
    protected final Class<T> entityClass;
    protected String nodeType;
    protected final AbstractJcrDAO<T> dao;
    private final Jcrom jcrom;

    protected JcrCrudService(JcrRepository repository, Jcrom jcrom, Class<T> entityClass) throws RepositoryException {
        this.repository = repository;
        this.jcrom = jcrom;
        this.entityClass = entityClass;
        this.dao = new AbstractJcrDAO<T>(entityClass, repository.getSession(), jcrom){};
        JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(entityClass);
        if (jcrNode != null) {
            this.nodeType = jcrNode.nodeType();
        }
        if (this.nodeType == null) {
            throw new JcrMappingException("Can not use JcrCrudService on a class with no node type, please annotate the class " + entityClass + " with the JcrNode annotations and specify its nodeType");
        }
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public Class<String> getIdClass() {
        return String.class;
    }

    public T delete(T t) {
        this.dao.remove(this.jcrom.getPath(t));
        return t;
    }

    public void delete(String s) {
        this.dao.remove(s);
    }

    public Iterable<T> delete(Iterable<T> ts) {
        ArrayList<T> deleted = new ArrayList<T>();
        for (T toDelete : ts) {
            deleted.add(this.delete(toDelete));
        }
        return deleted;
    }

    public T save(T t) {
        String path = this.jcrom.getPath(t);
        try {
            this.checkPath(path);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Unable to create the parent path " + path, (Throwable)e);
        }
        String name = this.jcrom.getName(t);
        if (path != null && this.exists(name)) {
            return (T)this.dao.update(t);
        }
        return (T)this.dao.create(t);
    }

    private void checkPath(String path) throws RepositoryException {
        if (path != null && this.repository.getJcromConfiguration().isCreatePath() && !this.repository.getSession().nodeExists(path)) {
            new JcrTools().findOrCreateNode(this.repository.getSession(), path);
        }
    }

    public Iterable<T> save(Iterable<T> ts) {
        ArrayList<T> saved = new ArrayList<T>();
        for (T tosave : ts) {
            saved.add(this.save(tosave));
        }
        return saved;
    }

    public T findOne(String name) {
        QueryResult r = this.executeJcrSql2Query(JcrQueryFactory.findOneQuery(this.nodeType, name));
        try {
            return this.readResult(r.getRows(), null).get(0);
        }
        catch (RepositoryException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    public T findOne(EntityFilter<T> tEntityFilter) {
        for (T entity : this.findAll()) {
            if (!tEntityFilter.accept(entity)) continue;
            return entity;
        }
        return null;
    }

    public boolean exists(String name) {
        QueryResult r = this.executeJcrSql2Query(JcrQueryFactory.findOneQuery(this.nodeType, name));
        try {
            return r.getRows().getSize() > 0L;
        }
        catch (RepositoryException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Iterable<T> findAll() {
        QueryResult r = this.executeJcrSql2Query(JcrQueryFactory.findAllQuery(this.nodeType));
        try {
            return this.readResult(r.getRows(), null);
        }
        catch (RepositoryException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    protected T getEntity(String path, NodeFilter filter) {
        return (T)this.dao.get(path, filter);
    }

    public Iterable<T> findAll(Iterable<String> strings) {
        ArrayList<T> entities = new ArrayList<T>();
        for (String ids : strings) {
            entities.add(this.findOne(ids));
        }
        return entities;
    }

    public Iterable<T> findAll(EntityFilter<T> tEntityFilter) {
        ArrayList<T> entities = new ArrayList<T>();
        for (T entity : this.findAll()) {
            if (!tEntityFilter.accept(entity)) continue;
            entities.add(entity);
        }
        return entities;
    }

    public long count() {
        QueryResult r = this.executeJcrSql2Query(JcrQueryFactory.findAllQuery(this.nodeType));
        try {
            return r.getRows().getSize();
        }
        catch (RepositoryException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void executeTransactionalBlock(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    public <A> A executeTransactionalBlock(Callable<A> aCallable) {
        throw new UnsupportedOperationException();
    }

    public TransactionManager getTransactionManager() {
        throw new UnsupportedOperationException();
    }

    public <R> FluentTransaction<R> transaction() {
        throw new UnsupportedOperationException();
    }

    public <R> FluentTransaction.Intermediate transaction(Callable<R> callable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T findOneByQuery(String query, String language) {
        QueryResult r = this.executeQuery(query, language);
        try {
            return this.readResult(r.getRows(), null).get(0);
        }
        catch (RepositoryException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    @Override
    public List<T> findByQuery(String query, String language) {
        QueryResult r = this.executeQuery(query, language);
        try {
            return this.readResult(r.getRows(), null);
        }
        catch (RepositoryException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    @Override
    public T findByPath(String absolutePath) {
        return (T)this.dao.get(absolutePath);
    }

    @Override
    public <A> A getAs(T entity, Class<A> clazz) {
        return this.getAs(this.jcrom.getPath(entity), clazz);
    }

    @Override
    public <A> A getAs(String path, Class<A> clazz) {
        try {
            return (A)this.jcrom.fromNode(clazz, PathUtils.getNode((String)path, (Session)this.repository.getSession()));
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    protected QueryResult executeQuery(String statement, String language) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            QueryManager queryManager = this.repository.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(statement, language);
            QueryResult queryResult = query.execute();
            return queryResult;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by SQL", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected List<T> readResult(RowIterator rowIterator, NodeFilter filter) throws RepositoryException {
        ArrayList<T> list = new ArrayList<T>();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.nextRow();
            String path = row.getValue("jcr:path").getString();
            T newInstance = this.getEntity(path, filter);
            list.add(newInstance);
        }
        return list;
    }

    protected QueryResult executeJcrSql2Query(String statement) {
        return this.executeQuery(statement, "JCR-SQL2");
    }
}

