/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcrom.runtime;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jcrom.Jcrom;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wisdom.api.model.Crud;
import org.wisdom.jcrom.conf.JcromConfiguration;
import org.wisdom.jcrom.object.JcrCrud;
import org.wisdom.jcrom.runtime.JcrCrudService;
import org.wisdom.jcrom.runtime.JcrRepository;

public class JcromBundleContext {
    private final Jcrom jcrom;
    private final JcromConfiguration jcromConfiguration;
    private final Map<Crud<?, ?>, ServiceRegistration> crudServiceRegistrations = new HashMap();

    public JcromBundleContext(Jcrom jcrom, JcromConfiguration jcromConfiguration) {
        this.jcrom = jcrom;
        this.jcromConfiguration = jcromConfiguration;
    }

    public void addCrudService(Class clazz, BundleContext bundleContext, JcrRepository repository) throws RepositoryException {
        this.jcrom.map(clazz);
        JcrCrudService jcromCrudService = new JcrCrudService(repository, this.jcrom, clazz);
        this.crudServiceRegistrations.put(jcromCrudService, this.registerCrud(bundleContext, jcromCrudService));
    }

    private ServiceRegistration registerCrud(BundleContext context, JcrCrudService crud) {
        Dictionary<String, String> prop = this.jcromConfiguration.toDictionary();
        prop.put("entity.class", (String)((Object)crud.getEntityClass()));
        prop.put("entity.classname", crud.getEntityClass().getName());
        ServiceRegistration serviceRegistration = context.registerService(new String[]{Crud.class.getName(), JcrCrud.class.getName()}, (Object)crud, prop);
        return serviceRegistration;
    }

    public void unregister() {
        this.removeCrudServices(this.crudServiceRegistrations.keySet());
    }

    protected void removeCrudServices(Collection<? extends Crud> cruds) {
        for (Crud crud : cruds) {
            this.crudServiceRegistrations.remove(crud).unregister();
        }
    }

    public Collection<Crud<?, ?>> getCruds() {
        return this.crudServiceRegistrations.keySet();
    }
}

