/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcrom.runtime;

import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.jcrom.conf.JcromConfiguration;
import org.wisdom.jcrom.runtime.BundleCrudComponent;
import org.wisdom.jcrom.runtime.JcrRepository;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Component(name="wisdom:jcrom:crudservice:factory")
@Instantiate(name="wisdom:jcrom:crudservice:provider")
public class JcromCrudProvider
implements BundleTrackerCustomizer<BundleCrudComponent> {
    InstanceManager __IM;
    private boolean __Flogger;
    private Logger logger;
    public static final String COMPONENT_NAME = "wisdom:jcrom:crudservice:factory";
    public static final String INSTANCE_NAME = "wisdom:jcrom:crudservice:provider";
    private boolean __FapplicationConfiguration;
    @Requires
    private ApplicationConfiguration applicationConfiguration;
    private boolean __FjcromConfiguration;
    private JcromConfiguration jcromConfiguration;
    private boolean __Fcontext;
    private final BundleContext context;
    private boolean __FbundleTracker;
    private BundleTracker<?> bundleTracker;
    private boolean __Frepository;
    @Requires
    private JcrRepository repository;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent;
    boolean __MgetRepository;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    ApplicationConfiguration __getapplicationConfiguration() {
        if (!this.__FapplicationConfiguration) {
            return this.applicationConfiguration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "applicationConfiguration");
    }

    void __setapplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__FapplicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "applicationConfiguration", (Object)applicationConfiguration);
    }

    JcromConfiguration __getjcromConfiguration() {
        if (!this.__FjcromConfiguration) {
            return this.jcromConfiguration;
        }
        return (JcromConfiguration)this.__IM.onGet((Object)this, "jcromConfiguration");
    }

    void __setjcromConfiguration(JcromConfiguration jcromConfiguration) {
        if (!this.__FjcromConfiguration) {
            this.jcromConfiguration = jcromConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "jcromConfiguration", (Object)jcromConfiguration);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    BundleTracker __getbundleTracker() {
        if (!this.__FbundleTracker) {
            return this.bundleTracker;
        }
        return (BundleTracker)this.__IM.onGet((Object)this, "bundleTracker");
    }

    void __setbundleTracker(BundleTracker bundleTracker) {
        if (!this.__FbundleTracker) {
            this.bundleTracker = bundleTracker;
            return;
        }
        this.__IM.onSet((Object)this, "bundleTracker", (Object)bundleTracker);
    }

    JcrRepository __getrepository() {
        if (!this.__Frepository) {
            return this.repository;
        }
        return (JcrRepository)this.__IM.onGet((Object)this, "repository");
    }

    void __setrepository(JcrRepository jcrRepository) {
        if (!this.__Frepository) {
            this.repository = jcrRepository;
            return;
        }
        this.__IM.onSet((Object)this, "repository", (Object)jcrRepository);
    }

    public JcromCrudProvider(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private JcromCrudProvider(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setlogger(LoggerFactory.getLogger(JcromCrudProvider.class));
        this.__setcontext(bundleContext);
    }

    private void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__setjcromConfiguration(JcromConfiguration.fromApplicationConfiguration(this.__getapplicationConfiguration()));
        if (this.__getjcromConfiguration() == null) {
            this.__getlogger().info("Confs is empty, stopping");
            return;
        }
        this.__setbundleTracker(new BundleTracker(this.__getcontext(), 32, (BundleTrackerCustomizer)this));
        this.__getbundleTracker().open();
    }

    private void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        if (this.__getjcromConfiguration().getPackages().isEmpty()) {
            return;
        }
        if (this.__getbundleTracker() != null) {
            this.__getbundleTracker().close();
        }
    }

    public BundleCrudComponent addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        BundleCrudComponent bundleCrudComponent;
        if (!this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent) {
            return this.__M_addingBundle(bundle, bundleEvent);
        }
        try {
            this.__IM.onEntry((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", new Object[]{bundle, bundleEvent});
            bundleCrudComponent = this.__M_addingBundle(bundle, bundleEvent);
            this.__IM.onExit((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", (Object)bundleCrudComponent);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", throwable);
            throw throwable;
        }
        return bundleCrudComponent;
    }

    private BundleCrudComponent __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        BundleCrudComponent cruds = new BundleCrudComponent(this.__getrepository());
        if (this.__getjcromConfiguration() != null) {
            for (String p : this.__getjcromConfiguration().getPackages()) {
                Enumeration enums = bundle.findEntries(JcromCrudProvider.packageNameToPath(p), "*.class", true);
                if (enums == null) continue;
                do {
                    URL entry = (URL)enums.nextElement();
                    cruds.addEntity(bundle, this.__getcontext(), entry);
                } while (enums.hasMoreElements());
                this.__getlogger().debug("Crud service has been added for " + p);
            }
        }
        return cruds;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, BundleCrudComponent cruds) {
        if (!this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent) {
            this.__M_modifiedBundle(bundle, bundleEvent, cruds);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent", new Object[]{bundle, bundleEvent, cruds});
            this.__M_modifiedBundle(bundle, bundleEvent, cruds);
            this.__IM.onExit((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent", throwable);
            throw throwable;
        }
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, BundleCrudComponent cruds) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, BundleCrudComponent cruds) {
        if (!this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent) {
            this.__M_removedBundle(bundle, bundleEvent, cruds);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent", new Object[]{bundle, bundleEvent, cruds});
            this.__M_removedBundle(bundle, bundleEvent, cruds);
            this.__IM.onExit((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent", throwable);
            throw throwable;
        }
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, BundleCrudComponent cruds) {
        cruds.remove();
    }

    public static String urlToClassName(URL url) {
        String path = url.getPath();
        return path.replace("/", ".").substring(1, path.lastIndexOf("."));
    }

    private static String packageNameToPath(String packageName) {
        return "/" + packageName.replace(".", "/");
    }

    public JcrRepository getRepository() {
        JcrRepository jcrRepository;
        if (!this.__MgetRepository) {
            return this.__M_getRepository();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepository", new Object[0]);
            jcrRepository = this.__M_getRepository();
            this.__IM.onExit((Object)this, "getRepository", (Object)jcrRepository);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepository", throwable);
            throw throwable;
        }
        return jcrRepository;
    }

    private JcrRepository __M_getRepository() {
        return this.__getrepository();
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.removedBundle(bundle, bundleEvent, (BundleCrudComponent)object);
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.modifiedBundle(bundle, bundleEvent, (BundleCrudComponent)object);
    }

    private Object __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        return this.addingBundle(bundle, bundleEvent);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("applicationConfiguration")) {
                this.__FapplicationConfiguration = true;
            }
            if (set.contains("bundleTracker")) {
                this.__FbundleTracker = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("jcromConfiguration")) {
                this.__FjcromConfiguration = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("repository")) {
                this.__Frepository = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent")) {
                this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$org_wisdom_jcrom_runtime_BundleCrudComponent = true;
            }
            if (set.contains("getRepository")) {
                this.__MgetRepository = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

