/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.annotations.scheduler.Async;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.concurrent.ManagedFutureTask;
import org.wisdom.api.exceptions.HttpException;
import org.wisdom.api.http.AsyncResult;
import org.wisdom.api.http.Result;
import org.wisdom.api.interception.Interceptor;
import org.wisdom.api.interception.RequestContext;

@Component
@Provides(specifications={Interceptor.class})
@Instantiate
public class AsyncInterceptor
extends Interceptor<Async> {
    InstanceManager __IM;
    boolean __M1___call;
    boolean __MResultRetriever___call;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncInterceptor.class);
    private boolean __Fexecutor;
    @Requires(filter="(name=wisdom-system-executor)", proxy=false)
    protected ManagedExecutorService executor;
    boolean __Mcall$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext;
    boolean __Mannotation;
    boolean __Mcall$java_lang_Object$org_wisdom_api_interception_RequestContext;

    ManagedExecutorService __getexecutor() {
        if (!this.__Fexecutor) {
            return this.executor;
        }
        return (ManagedExecutorService)this.__IM.onGet((Object)this, "executor");
    }

    void __setexecutor(ManagedExecutorService managedExecutorService) {
        if (!this.__Fexecutor) {
            this.executor = managedExecutorService;
            return;
        }
        this.__IM.onSet((Object)this, "executor", (Object)managedExecutorService);
    }

    public AsyncInterceptor() {
        this(null);
    }

    private AsyncInterceptor(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Result call(Async configuration, RequestContext context) throws Exception {
        Result result;
        if (!this.__Mcall$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext) {
            return this.__M_call(configuration, context);
        }
        try {
            this.__IM.onEntry((Object)this, "call$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext", new Object[]{configuration, context});
            result = this.__M_call(configuration, context);
            this.__IM.onExit((Object)this, "call$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "call$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_call(Async configuration, final RequestContext context) throws Exception {
        Callable<Object> callable = configuration.timeout() > 0L ? new ResultRetriever(context, configuration) : new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                Result result;
                if (!AsyncInterceptor.this.__M1___call) {
                    return this.__M_call();
                }
                try {
                    AsyncInterceptor.this.__IM.onEntry((Object)this, "1___call", new Object[0]);
                    result = this.__M_call();
                    AsyncInterceptor.this.__IM.onExit((Object)this, "1___call", (Object)result);
                }
                catch (Throwable throwable) {
                    AsyncInterceptor.this.__IM.onError((Object)this, "1___call", throwable);
                    throw throwable;
                }
                return result;
            }

            private Result __M_call() throws Exception {
                return context.proceed();
            }

            private Object __M_call() throws Exception {
                return this.call();
            }
        };
        return new AsyncResult((Callable)callable);
    }

    public Class<Async> annotation() {
        Class<Async> clazz;
        if (!this.__Mannotation) {
            return this.__M_annotation();
        }
        try {
            this.__IM.onEntry((Object)this, "annotation", new Object[0]);
            clazz = this.__M_annotation();
            this.__IM.onExit((Object)this, "annotation", clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "annotation", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class<Async> __M_annotation() {
        return Async.class;
    }

    private Result __M_call(Object object, RequestContext requestContext) throws Exception {
        return this.call((Async)object, requestContext);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("executor")) {
            this.__Fexecutor = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___call")) {
                this.__M1___call = true;
            }
            if (set.contains("ResultRetriever___call")) {
                this.__MResultRetriever___call = true;
            }
            if (set.contains("call$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$org_wisdom_api_annotations_scheduler_Async$org_wisdom_api_interception_RequestContext = true;
            }
            if (set.contains("annotation")) {
                this.__Mannotation = true;
            }
            if (set.contains("call$java_lang_Object$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$java_lang_Object$org_wisdom_api_interception_RequestContext = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class ResultRetriever
    implements Callable<Result> {
        private final RequestContext context;
        private final Async configuration;

        public ResultRetriever(RequestContext context, Async configuration) {
            this.context = context;
            this.configuration = configuration;
        }

        @Override
        public Result call() throws Exception {
            Result result;
            if (!AsyncInterceptor.this.__MResultRetriever___call) {
                return this.__M_call();
            }
            try {
                AsyncInterceptor.this.__IM.onEntry((Object)this, "ResultRetriever___call", new Object[0]);
                result = this.__M_call();
                AsyncInterceptor.this.__IM.onExit((Object)this, "ResultRetriever___call", (Object)result);
            }
            catch (Throwable throwable) {
                AsyncInterceptor.this.__IM.onError((Object)this, "ResultRetriever___call", throwable);
                throw throwable;
            }
            return result;
        }

        private Result __M_call() throws Exception {
            Result result;
            ManagedFutureTask task = AsyncInterceptor.this.__getexecutor().submit((Callable)new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    return ResultRetriever.this.context.proceed();
                }
            });
            try {
                result = (Result)task.get(this.configuration.timeout(), this.configuration.unit());
            }
            catch (TimeoutException e) {
                LOGGER.debug("Call on {} was cancelled because it took more than {} {}", new Object[]{this.context.route().getUrl(), this.configuration.unit(), this.configuration.timeout()});
                task.cancel(true);
                throw new HttpException(504, "Request timeout");
            }
            catch (InterruptedException e) {
                LOGGER.debug("Call on {} was interrupted", (Object)this.context.route().getUrl());
                throw new HttpException(504, "Request timeout");
            }
            catch (ExecutionException e) {
                throw new HttpException(500, "Computation error", (Throwable)e);
            }
            if (result == null) {
                throw new HttpException(500, "Computation error");
            }
            return result;
        }

        private Object __M_call() throws Exception {
            return this.call();
        }
    }
}

