/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.wisdom.api.concurrent.ExecutionContextService;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.concurrent.ManagedScheduledExecutorService;
import org.wisdom.api.concurrent.ManagedScheduledFutureTask;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.executors.AbstractManagedExecutorService;
import org.wisdom.executors.ScheduledTask;
import org.wisdom.executors.Task;

public class ManagedScheduledExecutorServiceImpl
extends AbstractManagedExecutorService
implements ManagedScheduledExecutorService {
    public ManagedScheduledExecutorServiceImpl(String name, Configuration configuration, List<ExecutionContextService> ecs) {
        this(name, (ManagedExecutorService.ThreadType)configuration.get("threadType", ManagedExecutorService.ThreadType.class, (Object)ManagedExecutorService.ThreadType.POOLED), configuration.getDuration("hungTime", TimeUnit.MILLISECONDS, 60000L), configuration.getIntegerWithDefault("coreSize", Integer.valueOf(5)), configuration.getIntegerWithDefault("priority", Integer.valueOf(5)), ecs);
    }

    public ManagedScheduledExecutorServiceImpl(String name, ManagedExecutorService.ThreadType tu, long hungTime, int coreSize, int priority, List<ExecutionContextService> ecs) {
        super(name, hungTime, ecs);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(tu == ManagedExecutorService.ThreadType.DAEMON).setNameFormat(name + "-%s").setPriority(priority).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ManagedScheduledExecutorServiceImpl.this.logger.error("Uncaught exception in thread '{}'", (Object)t.getName(), (Object)e);
            }
        });
        this.setInternalPool(new ScheduledThreadPoolExecutor(coreSize, builder.build()));
    }

    @Override
    protected <V> Task<V> getNewTaskFor(Runnable task, V result) {
        return new Task<V>(this.executor, task, result, this.createExecutionContext(), this.hungTime, this);
    }

    protected <V> Task<V> getNewTaskFor(Callable<V> callable) {
        return new Task<V>(this.executor, callable, this.createExecutionContext(), this.hungTime, this);
    }

    public <V> ManagedScheduledFutureTask<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTask<V> task = this.getNewScheduledTaskFor(callable, false);
        ScheduledFuture future = ((ScheduledExecutorService)this.executor).schedule(task.callable, delay, unit);
        task.submittedScheduledTask(future);
        return task;
    }

    private <V> ScheduledTask<V> getNewScheduledTaskFor(Callable<V> callable, boolean periodic) {
        return new ScheduledTask<V>(this.executor, callable, this.hungTime, periodic, (AbstractManagedExecutorService)this);
    }

    private ScheduledTask<Void> getNewScheduledTaskFor(Runnable command, boolean periodic) {
        return new ScheduledTask<Object>(this.executor, command, null, this.hungTime, periodic, (AbstractManagedExecutorService)this);
    }

    public ManagedScheduledFutureTask<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledTask<Void> task = this.getNewScheduledTaskFor(command, false);
        ScheduledFuture future = ((ScheduledExecutorService)this.executor).schedule(task.callable, delay, unit);
        task.submittedScheduledTask(future);
        return task;
    }

    public ManagedScheduledFutureTask<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ScheduledTask<Void> task = this.getNewScheduledTaskFor(command, true);
        ScheduledFuture<?> future = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(task.asRunnable(), initialDelay, period, unit);
        task.submittedScheduledTask(future);
        return task;
    }

    public ManagedScheduledFutureTask<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledTask<Void> task = this.getNewScheduledTaskFor(command, true);
        ScheduledFuture<?> future = ((ScheduledExecutorService)this.executor).scheduleWithFixedDelay(task.asRunnable(), initialDelay, delay, unit);
        task.submittedScheduledTask(future);
        return task;
    }
}

