/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors.scheduler;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.wisdom.api.annotations.scheduler.Every;
import org.wisdom.api.concurrent.ManagedScheduledFutureTask;
import org.wisdom.api.scheduler.Scheduled;
import org.wisdom.executors.scheduler.WisdomTaskScheduler;

public class Job {
    public static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().printZeroRarelyFirst().appendDays().appendSuffix("d", "d").printZeroRarelyLast().appendHours().appendSuffix("h", "h").printZeroRarelyLast().appendMinutes().appendSuffix("m", "m").printZeroRarelyLast().appendSeconds().appendSuffix("s", "s").toFormatter();
    private final Method method;
    private final Scheduled scheduled;
    private final TimeUnit unit;
    private ManagedScheduledFutureTask task;
    private long period;

    public Job(Scheduled scheduled, Method method, Every every) {
        this.method = method;
        this.scheduled = scheduled;
        if (every.period() > 0L) {
            this.period = every.period();
            this.unit = every.unit();
        } else {
            this.period = Job.getDurationFromPeriod(every);
            this.unit = TimeUnit.SECONDS;
            if (this.period == -1L) {
                throw new IllegalArgumentException("Cannot retrieve the period of the @Every annotation of " + method.getName() + ", neither the period as String nor as long was given");
            }
        }
    }

    public static long toDuration(Period period) {
        return period.toStandardSeconds().getSeconds();
    }

    public static long getDurationFromPeriod(Every every) {
        if (!Strings.isNullOrEmpty((String)every.value())) {
            return Job.toDuration(PERIOD_FORMATTER.parsePeriod(every.value()));
        }
        return -1L;
    }

    public Method method() {
        return this.method;
    }

    public Runnable function() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Job.this.method.invoke((Object)Job.this.scheduled, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    WisdomTaskScheduler.getLogger().error("Error while accessing to the scheduled method {}.{}", new Object[]{Job.this.scheduled.getClass().getName(), Job.this.method.getName(), e});
                }
                catch (InvocationTargetException e) {
                    WisdomTaskScheduler.getLogger().error("Error in scheduled method {}.{}", new Object[]{Job.this.scheduled.getClass().getName(), Job.this.method.getName(), e});
                }
            }
        };
    }

    public void submitted(ManagedScheduledFutureTask task) {
        this.task = task;
    }

    public ManagedScheduledFutureTask task() {
        return this.task;
    }

    public Scheduled scheduled() {
        return this.scheduled;
    }

    public long period() {
        return this.period;
    }

    public TimeUnit unit() {
        return this.unit;
    }
}

