/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.error;

import java.util.ArrayList;
import java.util.List;

public final class StackTraceUtils {
    private StackTraceUtils() {
    }

    public static List<StackTraceElement> cleanup(StackTraceElement[] stack) {
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        if (stack == null) {
            return elements;
        }
        for (StackTraceElement element : stack) {
            if (element.getMethodName().startsWith("__M_")) {
                String newMethodName = element.getMethodName().substring("__M_".length());
                elements.add(new StackTraceElement(element.getClassName(), newMethodName, element.getFileName(), element.getLineNumber()));
                continue;
            }
            if (element.getLineNumber() < 0) continue;
            elements.add(element);
        }
        return elements;
    }
}

