/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;

public class NodeCacheIterator
implements Iterator<NodeKey> {
    private final Queue<NodeKey> keys = new LinkedList<NodeKey>();
    private final NodeCache cache;
    private final NodeFilter filter;
    private final NodeKey startingNode;
    private NodeKey nextNode;

    public NodeCacheIterator(NodeCache cache, NodeKey startingNode) {
        this(cache, startingNode, null);
    }

    public NodeCacheIterator(NodeCache cache, NodeKey startingNode, NodeFilter filter) {
        CheckArg.isNotNull((Object)cache, (String)"cache");
        CheckArg.isNotNull((Object)startingNode, (String)"startingNode");
        this.cache = cache;
        this.startingNode = startingNode;
        this.keys.add(startingNode);
        this.filter = filter;
    }

    @Override
    public final boolean hasNext() {
        this.nextNode();
        return this.nextNode != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NodeKey next() {
        if (this.nextNode == null) {
            this.nextNode();
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
        }
        try {
            NodeKey nodeKey = this.nextNode;
            return nodeKey;
        }
        finally {
            this.nextNode = null;
        }
    }

    protected final void nextNode() {
        if (this.nextNode != null) {
            return;
        }
        while (true) {
            NodeKey nextKey;
            if ((nextKey = this.keys.poll()) == null) {
                this.nextNode = null;
                return;
            }
            CachedNode node = this.cache.getNode(nextKey);
            if (node == null) continue;
            if (this.filter != null && !this.filter.includeNode(node, this.cache)) {
                if (!this.filter.continueProcessingChildren(node, this.cache)) continue;
                nextKey = null;
            }
            Iterator<NodeKey> iter = node.getChildReferences(this.cache).getAllKeys();
            while (iter.hasNext()) {
                this.keys.add(iter.next());
            }
            this.nextNode = nextKey;
            if (nextKey != null) break;
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(nodes from ").append(this.cache);
        sb.append(" under ").append(this.cache.getNode(this.startingNode).getPath(this.cache));
        if (this.filter != null) {
            sb.append(" satisfying ").append(this.filter);
        }
        sb.append(")");
        return sb.toString();
    }

    public static interface NodeFilter {
        public boolean includeNode(CachedNode var1, NodeCache var2);

        public boolean continueProcessingChildren(CachedNode var1, NodeCache var2);
    }
}

