/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.index.IndexManager;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;

@Immutable
public final class DefaultManagedIndex
implements ManagedIndex {
    private final ProvidedIndex<?> index;
    private final IndexChangeAdapter adapter;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AtomicReference<IndexManager.IndexStatus> status = new AtomicReference<IndexManager.IndexStatus>(IndexManager.IndexStatus.ENABLED);

    public DefaultManagedIndex(ProvidedIndex<?> index, IndexChangeAdapter adapter) {
        assert (index != null);
        assert (adapter != null);
        this.index = index;
        this.adapter = adapter;
    }

    @Override
    public long estimateTotalCount() {
        return this.index.estimateTotalCount();
    }

    @Override
    public long estimateCardinality(List<Constraint> andedConstraints, Map<String, Object> variables) {
        return this.index.estimateCardinality(andedConstraints, variables);
    }

    @Override
    public Filter.Results filter(IndexConstraints constraints) {
        return this.index.filter(constraints);
    }

    @Override
    public IndexChangeAdapter getIndexChangeAdapter() {
        return this.adapter;
    }

    @Override
    public void enable(boolean enable) {
        this.enabled.set(enable);
        if (enable) {
            this.updateStatus(IndexManager.IndexStatus.DISABLED, IndexManager.IndexStatus.ENABLED);
        } else {
            this.updateStatus(IndexManager.IndexStatus.ENABLED, IndexManager.IndexStatus.DISABLED);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean destroyed) {
        try {
            this.index.shutdown(destroyed);
        }
        finally {
            this.enable(false);
        }
    }

    @Override
    public void clearAllData() {
        this.index.clearAllData();
    }

    @Override
    public IndexManager.IndexStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void updateStatus(IndexManager.IndexStatus currentStatus, IndexManager.IndexStatus newStatus) {
        this.status.compareAndSet(currentStatus, newStatus);
    }

    @Override
    public boolean requiresReindexing() {
        return this.index.requiresReindexing();
    }
}

