/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.modeshape.jcr.txn.Transactions;

public final class NoClientTransactions
extends Transactions {
    private static final ThreadLocal<Transactions.NestableThreadLocalTransaction> ACTIVE_TRANSACTION = new ThreadLocal();

    public NoClientTransactions(TransactionManager txnMgr) {
        super(txnMgr);
    }

    @Override
    public Transactions.Transaction currentTransaction() {
        return ACTIVE_TRANSACTION.get();
    }

    @Override
    public synchronized Transactions.Transaction begin() throws NotSupportedException, SystemException {
        Transactions.NestableThreadLocalTransaction tx = ACTIVE_TRANSACTION.get();
        if (tx == null) {
            this.txnMgr.begin();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Begin transaction {0}", new Object[]{this.currentTransactionId()});
            }
            tx = new Transactions.NestableThreadLocalTransaction(this, this.txnMgr, ACTIVE_TRANSACTION);
        }
        return tx.begin();
    }
}

