/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf;

import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;

public final class LayoutUtilities {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String HTML_ELEMENT_HTML = "html";
    public static final String HTML_ELEMENT_HEAD = "head";
    public static final String HTML_ELEMENT_TITLE = "title";
    public static final String HTML_ELEMENT_BODY = "body";

    private LayoutUtilities() {
    }

    public static boolean equalsAttributeName(Attribute attribute, String prefix, String name) {
        String attributename = attribute.getOriginalName();
        return attributename.equals(prefix + ":" + name) || attributename.equals("data-" + prefix + "-" + name);
    }

    public static String getAttributeValue(Element element, String prefix, String name) {
        String value = element.getAttributeValue(prefix + ":" + name);
        if (value == null) {
            value = element.getAttributeValue("data-" + prefix + "-" + name);
        }
        return value;
    }

    public static boolean hasAttribute(Element element, String prefix, String name) {
        return element.hasAttribute(prefix + ":" + name) || element.hasAttribute("data-" + prefix + "-" + name);
    }

    public static void pullAttributes(Element targetelement, Element sourceelement) {
        LayoutUtilities.pullAttributes(targetelement, sourceelement, false);
    }

    public static void pullAttributes(Element targetelement, Element sourceelement, boolean mergeonly) {
        if (sourceelement == null || targetelement == null) {
            return;
        }
        for (Attribute sourceattribute : sourceelement.getAttributeMap().values()) {
            if (LayoutUtilities.equalsAttributeName(sourceattribute, "layout", "fragment")) continue;
            if (LayoutUtilities.equalsAttributeName(sourceattribute, "th", "with")) {
                String mergedwithvalue = sourceattribute.getValue();
                String targetwithvalue = LayoutUtilities.getAttributeValue(targetelement, "th", "with");
                if (targetwithvalue != null) {
                    mergedwithvalue = mergedwithvalue + "," + targetwithvalue;
                }
                targetelement.setAttribute("th:with", mergedwithvalue);
                continue;
            }
            if ((!mergeonly || !targetelement.hasAttribute(sourceattribute.getNormalizedName())) && mergeonly) continue;
            targetelement.setAttribute(sourceattribute.getOriginalName(), sourceattribute.getValue());
        }
    }

    public static void pullContent(Element targetelement, Element sourceelement) {
        targetelement.clearChildren();
        targetelement.addChild(sourceelement.cloneNode(null, false));
        targetelement.getParent().extractChild(targetelement);
    }

    public static void removeAttribute(Element element, String prefix, String name) {
        element.removeAttribute(prefix + ":" + name);
        element.removeAttribute("data-" + prefix + "-" + name);
    }
}

