/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import nz.net.ultraq.thymeleaf.LayoutUtilities;
import nz.net.ultraq.thymeleaf.decorator.XmlElementDecorator;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;

public class HtmlHeadDecorator
extends XmlElementDecorator {
    @Override
    public void decorate(Element decoratorhtml, Element contenthead) {
        if (contenthead == null) {
            return;
        }
        Element decoratorhead = HtmlHeadDecorator.findElement(decoratorhtml, "head");
        if (decoratorhead == null) {
            decoratorhtml.insertChild(0, new Text(LayoutUtilities.LINE_SEPARATOR));
            decoratorhtml.insertChild(1, contenthead);
            return;
        }
        Element decoratortitle = HtmlHeadDecorator.findElement(decoratorhead, "title");
        Element contenttitle = HtmlHeadDecorator.findElement(contenthead, "title");
        Element resultingtitle = null;
        if (decoratortitle != null || contenttitle != null) {
            resultingtitle = new Element("title");
            if (decoratortitle != null) {
                HtmlHeadDecorator.extractTitle(decoratorhead, decoratortitle, "title-pattern::decorator-title", resultingtitle);
            }
            if (contenttitle != null) {
                HtmlHeadDecorator.extractTitle(contenthead, contenttitle, "title-pattern::content-title", resultingtitle);
            }
        }
        for (Node contentheadnode : contenthead.getChildren()) {
            decoratorhead.addChild(contentheadnode);
        }
        if (resultingtitle != null) {
            decoratorhead.insertChild(0, new Text(LayoutUtilities.LINE_SEPARATOR));
            decoratorhead.insertChild(1, resultingtitle);
        }
        super.decorate(decoratorhead, contenthead);
    }

    private static void extractTitle(Element head, Element title, String titlekey, Element result) {
        Text titletext = (Text)title.getFirstChild();
        result.clearChildren();
        result.addChild(titletext);
        if (LayoutUtilities.hasAttribute(title, "th", "text")) {
            result.setNodeProperty(titlekey, LayoutUtilities.getAttributeValue(title, "th", "text"));
            LayoutUtilities.removeAttribute(title, "th", "text");
        } else if (title.hasNodeProperty(titlekey)) {
            result.setNodeProperty(titlekey, title.getNodeProperty(titlekey));
        } else {
            result.setNodeProperty(titlekey, titletext.getContent());
        }
        LayoutUtilities.pullAttributes(result, title);
        head.removeChild(title);
    }
}

