/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private static final String ALPHA_NUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random RANDOM = new Random();

    public static String toString(Object target) {
        if (target == null) {
            return null;
        }
        return target.toString();
    }

    public static String abbreviate(Object target, int maxSize) {
        Validate.isTrue(maxSize >= 3, "Maximum size must be greater or equal to 3");
        if (target == null) {
            return null;
        }
        String str = target.toString();
        if (str.length() <= maxSize) {
            return str;
        }
        return str.substring(0, maxSize - 3) + "...";
    }

    public static Boolean equals(Object first, Object second) {
        if (first == null && second == null) {
            return Boolean.TRUE;
        }
        if (first == null || second == null) {
            return Boolean.FALSE;
        }
        return first.toString().equals(second.toString());
    }

    public static Boolean equalsIgnoreCase(Object first, Object second) {
        if (first == null && second == null) {
            return Boolean.TRUE;
        }
        if (first == null || second == null) {
            return Boolean.FALSE;
        }
        return first.toString().equalsIgnoreCase(second.toString());
    }

    public static Boolean contains(Object target, String fragment) {
        Validate.notNull(target, "Cannot apply contains on null");
        Validate.notNull(fragment, "Fragment cannot be null");
        return target.toString().contains(fragment);
    }

    public static Boolean containsIgnoreCase(Object target, String fragment, Locale locale) {
        Validate.notNull(target, "Cannot apply containsIgnoreCase on null");
        Validate.notNull(fragment, "Fragment cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        return target.toString().toUpperCase(locale).contains(fragment.toUpperCase(locale));
    }

    public static Boolean startsWith(Object target, String prefix) {
        Validate.notNull(target, "Cannot apply startsWith on null");
        Validate.notNull(prefix, "Prefix cannot be null");
        return target.toString().startsWith(prefix);
    }

    public static Boolean endsWith(Object target, String suffix) {
        Validate.notNull(target, "Cannot apply endsWith on null");
        Validate.notNull(suffix, "Suffix cannot be null");
        return target.toString().endsWith(suffix);
    }

    public static String substring(Object target, int beginIndex, int endIndex) {
        Validate.notNull(target, "Cannot apply substring on null");
        Validate.isTrue(beginIndex >= 0, "Begin index must be >= 0");
        return new String(target.toString().substring(beginIndex, endIndex));
    }

    public static String substring(Object target, int beginIndex) {
        Validate.notNull(target, "Cannot apply substring on null");
        String str = target.toString();
        int len = str.length();
        Validate.isTrue(beginIndex >= 0 && beginIndex < len, "beginIndex must be >= 0 and < " + len);
        return new String(str.substring(beginIndex));
    }

    public static String substringAfter(Object target, String substr) {
        Validate.notNull(target, "Cannot apply substringAfter on null");
        Validate.notNull(substr, "Parameter substring cannot be null");
        String str = target.toString();
        int index = str.indexOf(substr);
        if (index < 0) {
            return null;
        }
        return new String(str.substring(index + substr.length()));
    }

    public static String substringBefore(Object target, String substr) {
        Validate.notNull(target, "Cannot apply substringBefore on null");
        Validate.notNull(substr, "Parameter substring cannot be null");
        String str = target.toString();
        int index = str.indexOf(substr);
        if (index < 0) {
            return null;
        }
        return new String(str.substring(0, index));
    }

    public static String prepend(Object target, String prefix) {
        Validate.notNull(target, "Cannot apply prepend on null");
        Validate.notNull(prefix, "Prefix cannot be null");
        return prefix + target;
    }

    public static String append(Object target, String suffix) {
        Validate.notNull(target, "Cannot apply append on null");
        Validate.notNull(suffix, "Suffix cannot be null");
        return target + suffix;
    }

    public static String repeat(Object target, int times) {
        if (target == null) {
            return null;
        }
        String str = target.toString();
        StringBuilder strBuilder = new StringBuilder(str.length() * times + 10);
        for (int i = 0; i < times; ++i) {
            strBuilder.append(str);
        }
        return strBuilder.toString();
    }

    public static String concat(Object ... values) {
        return StringUtils.concatReplaceNulls("", values);
    }

    public static String concatReplaceNulls(String nullValue, Object ... values) {
        if (values == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            if (value == null) {
                sb.append(nullValue);
                continue;
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public static Integer indexOf(Object target, String fragment) {
        Validate.notNull(target, "Cannot apply indexOf on null");
        Validate.notNull(fragment, "Fragment cannot be null");
        return target.toString().indexOf(fragment);
    }

    public static boolean isEmpty(String target) {
        return target == null || target.length() == 0;
    }

    public static boolean isEmptyOrWhitespace(String target) {
        if (target == null) {
            return true;
        }
        int targetLen = target.length();
        if (targetLen == 0) {
            return true;
        }
        char c0 = target.charAt(0);
        if (c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z') {
            return false;
        }
        for (int i = 0; i < targetLen; ++i) {
            char c = target.charAt(i);
            if (c == ' ' || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String join(Object[] target, String separator) {
        Validate.notNull(target, "Cannot apply join on null");
        Validate.notNull(separator, "Separator cannot be null");
        StringBuilder sb = new StringBuilder();
        if (target.length > 0) {
            sb.append(target[0]);
            for (int i = 1; i < target.length; ++i) {
                sb.append(separator);
                sb.append(target[i]);
            }
        }
        return sb.toString();
    }

    public static String join(Iterable<?> target, String separator) {
        Validate.notNull(target, "Cannot apply join on null");
        Validate.notNull(separator, "Separator cannot be null");
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = target.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(separator);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static String join(Iterable<?> target, char separator) {
        Validate.notNull(target, "Cannot apply join on null");
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = target.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(separator);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static String[] split(Object target, String separator) {
        Validate.notNull(target, "Cannot apply split on null");
        Validate.notNull(separator, "Separator cannot be null");
        StringTokenizer strTok = new StringTokenizer(target.toString(), separator);
        int size = strTok.countTokens();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = strTok.nextToken();
        }
        return array;
    }

    public static Integer length(Object target) {
        Validate.notNull(target, "Cannot apply length on null");
        return target.toString().length();
    }

    public static String replace(Object target, String before, String after) {
        Validate.notNull(target, "Cannot apply replace on null");
        Validate.notNull(before, "Parameter \"before\" cannot be null");
        Validate.notNull(after, "Parameter \"after\" cannot be null");
        return target.toString().replace(before, after);
    }

    public static String toUpperCase(Object target, Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        return target.toString().toUpperCase(locale);
    }

    public static String toLowerCase(Object target, Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        return target.toString().toLowerCase(locale);
    }

    public static String trim(Object target) {
        if (target == null) {
            return null;
        }
        return target.toString().trim();
    }

    public static String capitalize(Object target) {
        if (target == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(target.toString());
        if (result.length() > 0) {
            result.setCharAt(0, Character.toTitleCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static String unCapitalize(Object target) {
        if (target == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(target.toString());
        if (result.length() > 0) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    private static int findNextWord(char[] buffer, int idx, char[] delimiterChars) {
        int len = buffer.length;
        if (idx < 0 || idx >= len) {
            return -1;
        }
        boolean foundDelimiters = idx == 0;
        for (int i = idx; i < len; ++i) {
            boolean isDelimiter;
            char ch = buffer[i];
            boolean bl = delimiterChars == null ? Character.isWhitespace(ch) : (isDelimiter = Arrays.binarySearch(delimiterChars, ch) >= 0);
            if (isDelimiter) {
                foundDelimiters = true;
                continue;
            }
            if (!foundDelimiters) continue;
            return i;
        }
        return -1;
    }

    public static String capitalizeWords(Object target) {
        return StringUtils.capitalizeWords(target, null);
    }

    public static String capitalizeWords(Object target, Object delimiters) {
        char[] delimiterChars;
        if (target == null) {
            return null;
        }
        char[] buffer = target.toString().toCharArray();
        char[] cArray = delimiterChars = delimiters == null ? null : delimiters.toString().toCharArray();
        if (delimiterChars != null) {
            Arrays.sort(delimiterChars);
        }
        int idx = 0;
        idx = StringUtils.findNextWord(buffer, idx, delimiterChars);
        while (idx != -1) {
            buffer[idx] = Character.toTitleCase(buffer[idx]);
            ++idx;
            idx = StringUtils.findNextWord(buffer, idx, delimiterChars);
        }
        return new String(buffer);
    }

    public static String escapeXml(Object target) {
        if (target == null) {
            return null;
        }
        try {
            return DOMUtils.escapeXml(target.toString(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while XML-escaping text", e);
        }
    }

    public static String escapeJavaScript(Object target) {
        if (target == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            StringUtils.escapeJavaAny((String)target, true, sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while JavaScript-escaping text", e);
        }
    }

    public static String escapeJava(Object target) {
        if (target == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            StringUtils.escapeJavaAny((String)target, false, sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while Java-escaping text", e);
        }
    }

    public static String unescapeJavaScript(Object target) {
        if (target == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            StringUtils.unescapeJavaAny((String)target, sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while JavaScript-unescaping text", e);
        }
    }

    public static String unescapeJava(Object target) {
        if (target == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            StringUtils.unescapeJavaAny((String)target, sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while Java-unescaping text", e);
        }
    }

    private static void escapeJavaAny(String text, boolean javaScript, Writer writer) throws IOException {
        Validate.notNull(writer, "Writer cannot be null");
        if (text == null) {
            return;
        }
        int textLen = text.length();
        block14: for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (c >= ' ' && c <= '\u007f') {
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        writer.write(92);
                        break;
                    }
                    case '\"': {
                        writer.write(92);
                        writer.write(34);
                        break;
                    }
                    case '\'': {
                        if (javaScript) {
                            writer.write(92);
                        }
                        writer.write(39);
                        break;
                    }
                    case '/': {
                        if (javaScript && i > 0 && text.charAt(i - 1) == '<') {
                            writer.write(92);
                        }
                        writer.write(47);
                        break;
                    }
                    case '>': {
                        if (javaScript && i > 1 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                            writer.write(92);
                        }
                        writer.write(62);
                        break;
                    }
                    default: {
                        writer.write(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\b': {
                    writer.write(92);
                    writer.write(98);
                    continue block14;
                }
                case '\f': {
                    writer.write(92);
                    writer.write(102);
                    continue block14;
                }
                case '\n': {
                    writer.write(92);
                    writer.write(110);
                    continue block14;
                }
                case '\r': {
                    writer.write(92);
                    writer.write(114);
                    continue block14;
                }
                case '\t': {
                    writer.write(92);
                    writer.write(116);
                    continue block14;
                }
                default: {
                    writer.write(StringUtils.unicodeEscape(c));
                }
            }
        }
    }

    private static String unicodeEscape(char c) {
        String hex = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
        if (c > '\u0fff') {
            return "\\u" + hex;
        }
        if (c > '\u00ff') {
            return "\\u0" + hex;
        }
        if (c > '\u000f') {
            return "\\u00" + hex;
        }
        return "\\u000" + hex;
    }

    private static void unescapeJavaAny(String text, Writer writer) throws IOException {
        Validate.notNull(writer, "Writer cannot be null");
        if (text == null) {
            return;
        }
        char[] unicodeSpec = new char[4];
        int unicodeOff = -1;
        boolean lastWasEscape = false;
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (unicodeOff >= 0) {
                unicodeSpec[unicodeOff++] = c;
                if (unicodeOff <= 3) continue;
                try {
                    writer.write((char)Integer.parseInt(new String(unicodeSpec), 16));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Unable to parse unicode value: " + new String(unicodeSpec), e);
                }
                unicodeOff = -1;
                continue;
            }
            if (lastWasEscape) {
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        break;
                    }
                    case '\"': {
                        writer.write(34);
                        break;
                    }
                    case '\'': {
                        writer.write(39);
                        break;
                    }
                    case 'b': {
                        writer.write(8);
                        break;
                    }
                    case 'f': {
                        writer.write(12);
                        break;
                    }
                    case 'n': {
                        writer.write(10);
                        break;
                    }
                    case 'r': {
                        writer.write(13);
                        break;
                    }
                    case 't': {
                        writer.write(9);
                        break;
                    }
                    case 'u': {
                        unicodeOff = 0;
                        break;
                    }
                    default: {
                        writer.write(c);
                    }
                }
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            writer.write(c);
            lastWasEscape = false;
        }
        if (unicodeOff >= 0) {
            writer.write(92);
            writer.write(117);
            writer.write(unicodeSpec, 0, unicodeOff);
        } else if (lastWasEscape) {
            writer.write(92);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String randomAlphanumeric(int count) {
        StringBuilder strBuilder = new StringBuilder(count);
        int anLen = ALPHA_NUMERIC.length();
        Random random = RANDOM;
        synchronized (random) {
            for (int i = 0; i < count; ++i) {
                strBuilder.append(ALPHA_NUMERIC.charAt(RANDOM.nextInt(anLen)));
            }
        }
        return strBuilder.toString();
    }

    private StringUtils() {
    }
}

