/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ognl.OgnlRuntime;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.templateresolver.TemplateResolver;
import org.wisdom.api.asset.Assets;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;
import org.wisdom.api.templates.TemplateEngine;
import org.wisdom.template.thymeleaf.impl.ThymeLeafTemplateImplementation;
import org.wisdom.template.thymeleaf.impl.WisdomTemplateEngine;
import org.wisdom.template.thymeleaf.impl.WisdomURLResourceResolver;

@Component(immediate=true)
@Provides(specifications={ThymeleafTemplateCollector.class, TemplateEngine.class})
@Instantiate(name="Thymeleaf template engine")
public class ThymeleafTemplateCollector
implements TemplateEngine,
Pojo {
    InstanceManager __IM;
    public static final String THYMELEAF_TEMPLATE_EXTENSION = "thl.html";
    public static final String THYMELEAF_ENGINE_NAME = "thymeleaf";
    private boolean __FmessageResolver;
    @Requires
    IMessageResolver messageResolver;
    private boolean __Fcontext;
    private final BundleContext context;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ThymeleafTemplateCollector.class.getName());
    private boolean __Fregistrations;
    private Map<ThymeLeafTemplateImplementation, ServiceRegistration<Template>> registrations;
    private boolean __Fengine;
    WisdomTemplateEngine engine;
    private boolean __Frouter;
    @Requires
    private Router router;
    private boolean __Fassets;
    @Requires(optional=true)
    private Assets assets;
    private boolean __Fdialects;
    Set<IDialect> dialects;
    boolean __Mstop;
    boolean __MupdatedTemplate$org_osgi_framework_Bundle$java_io_File;
    boolean __MgetTemplateByFile$java_io_File;
    boolean __MgetTemplateByURL$java_net_URL;
    boolean __MdeleteTemplate$java_io_File;
    boolean __MaddTemplate$org_osgi_framework_Bundle$java_net_URL;
    boolean __Mconfigure;
    boolean __MbindDialect$org_thymeleaf_dialect_IDialect;
    boolean __MunbindDialect$org_thymeleaf_dialect_IDialect;
    boolean __MgetTemplates;
    boolean __Mname;
    boolean __Mextension;
    boolean __MgetTemplateByResourceName$java_lang_String;
    boolean __MupdatedTemplate;
    boolean __MdeleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation;
    boolean __MclearMethodCaches;

    IMessageResolver __getmessageResolver() {
        if (!this.__FmessageResolver) {
            return this.messageResolver;
        }
        return (IMessageResolver)this.__IM.onGet((Object)this, "messageResolver");
    }

    void __setmessageResolver(IMessageResolver iMessageResolver) {
        if (!this.__FmessageResolver) {
            this.messageResolver = iMessageResolver;
            return;
        }
        this.__IM.onSet((Object)this, "messageResolver", (Object)iMessageResolver);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Map __getregistrations() {
        if (!this.__Fregistrations) {
            return this.registrations;
        }
        return (Map)this.__IM.onGet((Object)this, "registrations");
    }

    void __setregistrations(Map map) {
        if (!this.__Fregistrations) {
            this.registrations = map;
            return;
        }
        this.__IM.onSet((Object)this, "registrations", (Object)map);
    }

    WisdomTemplateEngine __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (WisdomTemplateEngine)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(WisdomTemplateEngine wisdomTemplateEngine) {
        if (!this.__Fengine) {
            this.engine = wisdomTemplateEngine;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)wisdomTemplateEngine);
    }

    Router __getrouter() {
        if (!this.__Frouter) {
            return this.router;
        }
        return (Router)this.__IM.onGet((Object)this, "router");
    }

    void __setrouter(Router router) {
        if (!this.__Frouter) {
            this.router = router;
            return;
        }
        this.__IM.onSet((Object)this, "router", (Object)router);
    }

    Assets __getassets() {
        if (!this.__Fassets) {
            return this.assets;
        }
        return (Assets)this.__IM.onGet((Object)this, "assets");
    }

    void __setassets(Assets assets) {
        if (!this.__Fassets) {
            this.assets = assets;
            return;
        }
        this.__IM.onSet((Object)this, "assets", (Object)assets);
    }

    Set __getdialects() {
        if (!this.__Fdialects) {
            return this.dialects;
        }
        return (Set)this.__IM.onGet((Object)this, "dialects");
    }

    void __setdialects(Set set) {
        if (!this.__Fdialects) {
            this.dialects = set;
            return;
        }
        this.__IM.onSet((Object)this, "dialects", (Object)set);
    }

    public ThymeleafTemplateCollector(BundleContext context) {
        this(null, context);
    }

    private ThymeleafTemplateCollector(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setregistrations(new ConcurrentHashMap());
        this.__setdialects(new HashSet());
        this.__setcontext(context);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        for (ServiceRegistration reg : this.__getregistrations().values()) {
            try {
                reg.unregister();
            }
            catch (Exception exception) {}
        }
        this.__getregistrations().clear();
    }

    public void updatedTemplate(Bundle bundle, File templateFile) {
        if (!this.__MupdatedTemplate$org_osgi_framework_Bundle$java_io_File) {
            this.__M_updatedTemplate(bundle, templateFile);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updatedTemplate$org_osgi_framework_Bundle$java_io_File", new Object[]{bundle, templateFile});
            this.__M_updatedTemplate(bundle, templateFile);
            this.__IM.onExit((Object)this, "updatedTemplate$org_osgi_framework_Bundle$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updatedTemplate$org_osgi_framework_Bundle$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_updatedTemplate(Bundle bundle, File templateFile) {
        ThymeLeafTemplateImplementation template = this.getTemplateByFile(templateFile);
        if (template != null) {
            LOGGER.info("Thymeleaf template updated for {} ({})", (Object)templateFile.getAbsoluteFile(), (Object)template.fullName());
            this.updatedTemplate();
        } else {
            try {
                this.addTemplate(bundle, templateFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    private ThymeLeafTemplateImplementation getTemplateByFile(File templateFile) {
        ThymeLeafTemplateImplementation thymeLeafTemplateImplementation;
        if (!this.__MgetTemplateByFile$java_io_File) {
            return this.__M_getTemplateByFile(templateFile);
        }
        try {
            this.__IM.onEntry((Object)this, "getTemplateByFile$java_io_File", new Object[]{templateFile});
            thymeLeafTemplateImplementation = this.__M_getTemplateByFile(templateFile);
            this.__IM.onExit((Object)this, "getTemplateByFile$java_io_File", (Object)thymeLeafTemplateImplementation);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTemplateByFile$java_io_File", throwable);
            throw throwable;
        }
        return thymeLeafTemplateImplementation;
    }

    private ThymeLeafTemplateImplementation __M_getTemplateByFile(File templateFile) {
        try {
            return this.getTemplateByURL(templateFile.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private ThymeLeafTemplateImplementation getTemplateByURL(URL url) {
        ThymeLeafTemplateImplementation thymeLeafTemplateImplementation;
        if (!this.__MgetTemplateByURL$java_net_URL) {
            return this.__M_getTemplateByURL(url);
        }
        try {
            this.__IM.onEntry((Object)this, "getTemplateByURL$java_net_URL", new Object[]{url});
            thymeLeafTemplateImplementation = this.__M_getTemplateByURL(url);
            this.__IM.onExit((Object)this, "getTemplateByURL$java_net_URL", (Object)thymeLeafTemplateImplementation);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTemplateByURL$java_net_URL", throwable);
            throw throwable;
        }
        return thymeLeafTemplateImplementation;
    }

    private ThymeLeafTemplateImplementation __M_getTemplateByURL(URL url) {
        Set list = this.__getregistrations().keySet();
        for (ThymeLeafTemplateImplementation template : list) {
            if (!template.getURL().sameFile(url)) continue;
            return template;
        }
        return null;
    }

    public void deleteTemplate(File templateFile) {
        if (!this.__MdeleteTemplate$java_io_File) {
            this.__M_deleteTemplate(templateFile);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteTemplate$java_io_File", new Object[]{templateFile});
            this.__M_deleteTemplate(templateFile);
            this.__IM.onExit((Object)this, "deleteTemplate$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteTemplate$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_deleteTemplate(File templateFile) {
        ThymeLeafTemplateImplementation template = this.getTemplateByFile(templateFile);
        if (template != null) {
            this.deleteTemplate(template);
        }
    }

    public ThymeLeafTemplateImplementation addTemplate(Bundle bundle, URL templateURL) {
        ThymeLeafTemplateImplementation thymeLeafTemplateImplementation;
        if (!this.__MaddTemplate$org_osgi_framework_Bundle$java_net_URL) {
            return this.__M_addTemplate(bundle, templateURL);
        }
        try {
            this.__IM.onEntry((Object)this, "addTemplate$org_osgi_framework_Bundle$java_net_URL", new Object[]{bundle, templateURL});
            thymeLeafTemplateImplementation = this.__M_addTemplate(bundle, templateURL);
            this.__IM.onExit((Object)this, "addTemplate$org_osgi_framework_Bundle$java_net_URL", (Object)thymeLeafTemplateImplementation);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addTemplate$org_osgi_framework_Bundle$java_net_URL", throwable);
            throw throwable;
        }
        return thymeLeafTemplateImplementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThymeLeafTemplateImplementation __M_addTemplate(Bundle bundle, URL templateURL) {
        ThymeLeafTemplateImplementation template = this.getTemplateByURL(templateURL);
        if (template != null) {
            return template;
        }
        ThymeleafTemplateCollector thymeleafTemplateCollector = this;
        synchronized (thymeleafTemplateCollector) {
            template = new ThymeLeafTemplateImplementation(this.__getengine(), templateURL, this.__getrouter(), this.__getassets(), bundle);
        }
        ServiceRegistration reg = this.__getcontext().registerService(Template.class, (Object)template, template.getServiceProperties());
        this.__getregistrations().put(template, reg);
        LOGGER.info("Thymeleaf template added for {}", (Object)templateURL.toExternalForm());
        return template;
    }

    public synchronized void configure() {
        if (!this.__Mconfigure) {
            this.__M_configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__M_configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_configure() {
        String mode = this.__getconfiguration().getWithDefault("application.template.thymeleaf.mode", "HTML5");
        int ttl = this.__getconfiguration().getIntegerWithDefault("application.template.thymeleaf.ttl", Integer.valueOf(60000));
        if (this.__getconfiguration().isDev()) {
            ttl = 1;
        }
        LOGGER.info("Thymeleaf configuration: mode={}, ttl={}", (Object)mode, (Object)ttl);
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.__setengine(new WisdomTemplateEngine(this.__getdialects()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        TemplateResolver resolver = new TemplateResolver();
        resolver.setResourceResolver(new WisdomURLResourceResolver(this));
        resolver.setTemplateMode(mode);
        resolver.setCacheTTLMs(Long.valueOf(ttl));
        this.__getengine().setTemplateResolver(resolver);
        this.__getengine().setMessageResolver(this.__getmessageResolver());
        this.__getengine().initialize();
    }

    public synchronized void bindDialect(IDialect dialect) {
        if (!this.__MbindDialect$org_thymeleaf_dialect_IDialect) {
            this.__M_bindDialect(dialect);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindDialect$org_thymeleaf_dialect_IDialect", new Object[]{dialect});
            this.__M_bindDialect(dialect);
            this.__IM.onExit((Object)this, "bindDialect$org_thymeleaf_dialect_IDialect", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindDialect$org_thymeleaf_dialect_IDialect", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __M_bindDialect(IDialect dialect) {
        LOGGER.info("Binding a new dialect using the prefix '{}' and containing {}", (Object)dialect.getPrefix(), dialect.getProcessors());
        if (this.__getdialects().add(dialect)) {
            this.configure();
            for (Template template : this.getTemplates()) {
                ((ThymeLeafTemplateImplementation)template).updateEngine(this.__getengine());
            }
        }
    }

    public synchronized void unbindDialect(IDialect dialect) {
        if (!this.__MunbindDialect$org_thymeleaf_dialect_IDialect) {
            this.__M_unbindDialect(dialect);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindDialect$org_thymeleaf_dialect_IDialect", new Object[]{dialect});
            this.__M_unbindDialect(dialect);
            this.__IM.onExit((Object)this, "unbindDialect$org_thymeleaf_dialect_IDialect", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindDialect$org_thymeleaf_dialect_IDialect", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindDialect(IDialect dialect) {
        LOGGER.info("Binding a new dialect {}, processors: {}", (Object)dialect.getPrefix(), dialect.getProcessors());
        if (this.__getdialects().remove(dialect)) {
            this.configure();
            for (Template template : this.getTemplates()) {
                ((ThymeLeafTemplateImplementation)template).updateEngine(this.__getengine());
            }
        }
    }

    public Collection<Template> getTemplates() {
        Collection<Template> collection;
        if (!this.__MgetTemplates) {
            return this.__M_getTemplates();
        }
        try {
            this.__IM.onEntry((Object)this, "getTemplates", new Object[0]);
            collection = this.__M_getTemplates();
            this.__IM.onExit((Object)this, "getTemplates", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTemplates", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<Template> __M_getTemplates() {
        return new ArrayList<Template>(this.__getregistrations().keySet());
    }

    public String name() {
        String string;
        if (!this.__Mname) {
            return this.__M_name();
        }
        try {
            this.__IM.onEntry((Object)this, "name", new Object[0]);
            string = this.__M_name();
            this.__IM.onExit((Object)this, "name", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "name", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_name() {
        return THYMELEAF_ENGINE_NAME;
    }

    public String extension() {
        String string;
        if (!this.__Mextension) {
            return this.__M_extension();
        }
        try {
            this.__IM.onEntry((Object)this, "extension", new Object[0]);
            string = this.__M_extension();
            this.__IM.onExit((Object)this, "extension", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "extension", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_extension() {
        return THYMELEAF_TEMPLATE_EXTENSION;
    }

    public ThymeLeafTemplateImplementation getTemplateByResourceName(String resourceName) {
        ThymeLeafTemplateImplementation thymeLeafTemplateImplementation;
        if (!this.__MgetTemplateByResourceName$java_lang_String) {
            return this.__M_getTemplateByResourceName(resourceName);
        }
        try {
            this.__IM.onEntry((Object)this, "getTemplateByResourceName$java_lang_String", new Object[]{resourceName});
            thymeLeafTemplateImplementation = this.__M_getTemplateByResourceName(resourceName);
            this.__IM.onExit((Object)this, "getTemplateByResourceName$java_lang_String", (Object)thymeLeafTemplateImplementation);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTemplateByResourceName$java_lang_String", throwable);
            throw throwable;
        }
        return thymeLeafTemplateImplementation;
    }

    private ThymeLeafTemplateImplementation __M_getTemplateByResourceName(String resourceName) {
        Set list = this.__getregistrations().keySet();
        for (ThymeLeafTemplateImplementation template : list) {
            if (template.fullName().endsWith(resourceName) || template.fullName().endsWith(resourceName + "." + this.extension())) {
                return template;
            }
            if (!template.name().equals(resourceName)) continue;
            return template;
        }
        return null;
    }

    public synchronized void updatedTemplate() {
        if (!this.__MupdatedTemplate) {
            this.__M_updatedTemplate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updatedTemplate", new Object[0]);
            this.__M_updatedTemplate();
            this.__IM.onExit((Object)this, "updatedTemplate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updatedTemplate", throwable);
            throw throwable;
        }
    }

    private void __M_updatedTemplate() {
        this.__getengine().getCacheManager().clearAllCaches();
    }

    public void deleteTemplate(ThymeLeafTemplateImplementation template) {
        if (!this.__MdeleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation) {
            this.__M_deleteTemplate(template);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation", new Object[]{template});
            this.__M_deleteTemplate(template);
            this.__IM.onExit((Object)this, "deleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_deleteTemplate(ThymeLeafTemplateImplementation template) {
        try {
            ServiceRegistration reg = (ServiceRegistration)this.__getregistrations().remove(template);
            if (reg != null) {
                reg.unregister();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThymeleafTemplateCollector thymeleafTemplateCollector = this;
        synchronized (thymeleafTemplateCollector) {
            this.__getengine().getCacheManager().clearAllCaches();
        }
        OgnlRuntime.clearCache();
        this.clearMethodCaches();
    }

    private void clearMethodCaches() {
        if (!this.__MclearMethodCaches) {
            this.__M_clearMethodCaches();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "clearMethodCaches", new Object[0]);
            this.__M_clearMethodCaches();
            this.__IM.onExit((Object)this, "clearMethodCaches", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "clearMethodCaches", throwable);
            throw throwable;
        }
    }

    private void __M_clearMethodCaches() {
        try {
            Field cacheGetMethod = OgnlRuntime.class.getDeclaredField("cacheGetMethod");
            Field cacheSetMethod = OgnlRuntime.class.getDeclaredField("cacheSetMethod");
            if (!cacheGetMethod.isAccessible()) {
                cacheGetMethod.setAccessible(true);
            }
            if (!cacheSetMethod.isAccessible()) {
                cacheSetMethod.setAccessible(true);
            }
            ((Map)cacheGetMethod.get(null)).clear();
            ((Map)cacheSetMethod.get(null)).clear();
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Cannot clean Thymeleaf cache, an exception has been thrown while clearing the Method caches, this may introduce leaks", (Throwable)e);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("assets")) {
                this.__Fassets = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("dialects")) {
                this.__Fdialects = true;
            }
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("messageResolver")) {
                this.__FmessageResolver = true;
            }
            if (set.contains("registrations")) {
                this.__Fregistrations = true;
            }
            if (set.contains("router")) {
                this.__Frouter = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("updatedTemplate$org_osgi_framework_Bundle$java_io_File")) {
                this.__MupdatedTemplate$org_osgi_framework_Bundle$java_io_File = true;
            }
            if (set.contains("getTemplateByFile$java_io_File")) {
                this.__MgetTemplateByFile$java_io_File = true;
            }
            if (set.contains("getTemplateByURL$java_net_URL")) {
                this.__MgetTemplateByURL$java_net_URL = true;
            }
            if (set.contains("deleteTemplate$java_io_File")) {
                this.__MdeleteTemplate$java_io_File = true;
            }
            if (set.contains("addTemplate$org_osgi_framework_Bundle$java_net_URL")) {
                this.__MaddTemplate$org_osgi_framework_Bundle$java_net_URL = true;
            }
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("bindDialect$org_thymeleaf_dialect_IDialect")) {
                this.__MbindDialect$org_thymeleaf_dialect_IDialect = true;
            }
            if (set.contains("unbindDialect$org_thymeleaf_dialect_IDialect")) {
                this.__MunbindDialect$org_thymeleaf_dialect_IDialect = true;
            }
            if (set.contains("getTemplates")) {
                this.__MgetTemplates = true;
            }
            if (set.contains("name")) {
                this.__Mname = true;
            }
            if (set.contains("extension")) {
                this.__Mextension = true;
            }
            if (set.contains("getTemplateByResourceName$java_lang_String")) {
                this.__MgetTemplateByResourceName$java_lang_String = true;
            }
            if (set.contains("updatedTemplate")) {
                this.__MupdatedTemplate = true;
            }
            if (set.contains("deleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation")) {
                this.__MdeleteTemplate$org_wisdom_template_thymeleaf_impl_ThymeLeafTemplateImplementation = true;
            }
            if (set.contains("clearMethodCaches")) {
                this.__MclearMethodCaches = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

