/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.osgi.framework.Bundle;
import org.wisdom.api.Controller;
import org.wisdom.api.asset.Assets;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;
import org.wisdom.template.thymeleaf.impl.WisdomTemplateEngine;

public class ThymeLeafTemplateImplementation
implements Template {
    public static final String THYME_LEAF_ENGINE_NAME = "thymeleaf";
    public static final String TEMPLATES = "/templates/";
    private final URL url;
    private final String name;
    private final Router router;
    private final Assets assets;
    private final Bundle bundle;
    private WisdomTemplateEngine templateEngine;

    public ThymeLeafTemplateImplementation(WisdomTemplateEngine templateEngine, File templateFile, Router router, Assets assets, Bundle source) throws MalformedURLException {
        this(templateEngine, templateFile.toURI().toURL(), router, assets, source);
    }

    public ThymeLeafTemplateImplementation(WisdomTemplateEngine templateEngine, URL templateURL, Router router, Assets assets, Bundle source) {
        this.templateEngine = templateEngine;
        this.url = templateURL;
        this.bundle = source;
        String externalForm = templateURL.toExternalForm();
        int indexOfTemplates = externalForm.indexOf(TEMPLATES);
        this.name = indexOfTemplates == -1 ? FilenameUtils.getBaseName((String)templateURL.getFile()) : externalForm.substring(indexOfTemplates + TEMPLATES.length(), externalForm.length() - ("thl.html".length() + 1));
        this.router = router;
        this.assets = assets;
    }

    public synchronized void updateEngine(WisdomTemplateEngine engine) {
        this.templateEngine = engine;
    }

    public URL getURL() {
        return this.url;
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return this.url.toExternalForm();
    }

    public String engine() {
        return THYME_LEAF_ENGINE_NAME;
    }

    public String mimetype() {
        return "text/html";
    }

    public synchronized Renderable<?> render(Controller controller, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(variables);
        if (!map.containsKey("__bundle__")) {
            map.put("__bundle__", this.bundle);
        }
        return this.templateEngine.process(this, controller, this.router, this.assets, map);
    }

    public Renderable<?> render(Controller controller) {
        return this.render(controller, Collections.emptyMap());
    }

    public Dictionary<String, ?> getServiceProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("name", this.name());
        ((Dictionary)props).put("fullName", this.fullName());
        ((Dictionary)props).put("mimetype", this.mimetype());
        ((Dictionary)props).put("engine", this.engine());
        return props;
    }
}

