/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.impl;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.wisdom.template.thymeleaf.ThymeleafTemplateCollector;
import org.wisdom.template.thymeleaf.impl.ThymeLeafTemplateImplementation;

public class WisdomURLResourceResolver
implements IResourceResolver {
    public static final String THYMELEAF_FILE_RESOLVER = "THYMELEAF_FILE_RESOLVER";
    private final ThymeleafTemplateCollector engine;

    public WisdomURLResourceResolver(ThymeleafTemplateCollector collector) {
        this.engine = collector;
    }

    @Override
    public String getName() {
        return THYMELEAF_FILE_RESOLVER;
    }

    @Override
    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        ThymeLeafTemplateImplementation template = this.engine.getTemplateByResourceName(resourceName);
        if (template == null) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot resolve the template {}, neither {} nor {}.thl.html exist in the template directory or is available in bundles.", new Object[]{resourceName, resourceName, resourceName});
        } else {
            try {
                return template.getURL().openStream();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot resolve the template {} ({}): cannot open the file.", new Object[]{resourceName, template.getURL().toExternalForm(), e});
            }
        }
        return null;
    }
}

