/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.Controller;
import org.wisdom.api.cookies.FlashCookie;
import org.wisdom.api.cookies.SessionCookie;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.HeaderNames;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Results;
import org.wisdom.api.http.Status;
import org.wisdom.api.router.Route;
import org.wisdom.api.templates.Template;

public class DefaultController
extends Results
implements Status,
HeaderNames,
Controller {
    private Logger logger;

    public Logger logger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        }
        return this.logger;
    }

    public Context context() {
        Context ctxt = Context.CONTEXT.get();
        if (ctxt == null) {
            throw new IllegalStateException("No context set from " + Thread.currentThread().getName());
        }
        return ctxt;
    }

    public Request request() {
        return this.context().request();
    }

    public SessionCookie session() {
        return this.context().session();
    }

    public void session(String key, String value) {
        this.session().put(key, value);
    }

    public String session(String key) {
        return this.session().get(key);
    }

    public FlashCookie flash() {
        return this.context().flash();
    }

    public void flash(String key, String value) {
        this.flash().put(key, value);
    }

    public String flash(String key) {
        return this.flash().get(key);
    }

    @Override
    public List<Route> routes() {
        return Collections.emptyList();
    }

    public Renderable<?> render(Template template, Map<String, Object> parameters) {
        return template.render(this, parameters);
    }

    public Renderable<?> render(Template template, Object ... parameters) {
        HashMap map = Maps.newHashMap();
        String key = null;
        for (Object parameter : parameters) {
            if (key == null) {
                if (!(parameter instanceof String)) {
                    throw new IllegalArgumentException("The template variable name " + parameter + " must be a string");
                }
                key = (String)parameter;
                continue;
            }
            map.put(key, parameter);
            key = null;
        }
        if (key != null) {
            throw new IllegalArgumentException("Illegal number of parameter, the variable " + key + " has no value");
        }
        return template.render(this, map);
    }

    public Renderable<?> render(Template template) {
        return template.render(this);
    }
}

