/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableObject
implements Renderable<Object> {
    private final Object object;
    private String serialized;

    public RenderableObject(Object o) {
        this.object = o;
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        if (this.serialized == null) {
            throw new RenderableException("Serialization required before rendering");
        }
        return new ByteArrayInputStream(this.serialized.getBytes(Charsets.UTF_8));
    }

    @Override
    public void setSerializedForm(String serialized) {
        this.serialized = serialized;
    }

    @Override
    public boolean mustBeChunked() {
        return false;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String mimetype() {
        return null;
    }

    @Override
    public Object content() {
        return this.object;
    }

    @Override
    public boolean requireSerializer() {
        return true;
    }
}

