/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableString
implements Renderable<String> {
    private String rendered;
    private String type;
    private boolean needSerializer = false;

    public RenderableString(String content) {
        this(content, null);
    }

    public RenderableString(StringBuilder content) {
        this(content.toString(), null);
    }

    public RenderableString(StringBuffer content) {
        this(content.toString(), null);
    }

    public RenderableString(Object object) {
        this(object.toString(), null);
    }

    public RenderableString(Object object, String type) {
        this(object.toString(), type);
    }

    public RenderableString(StringWriter content) {
        this(content.toString(), null);
    }

    public RenderableString(String content, String type) {
        this.rendered = content;
        this.type = type;
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        byte[] bytes;
        if (result != null) {
            if (result.getCharset() == null) {
                result.with(Charsets.UTF_8);
            }
            bytes = this.rendered.getBytes(result.getCharset());
        } else {
            bytes = this.rendered.getBytes(Charsets.UTF_8);
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public long length() {
        return this.rendered.length();
    }

    @Override
    public String mimetype() {
        if (this.type == null) {
            return "text/html";
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (type.equals("application/json")) {
            this.needSerializer = !(this.rendered.startsWith("{") && this.rendered.endsWith("}") || this.rendered.startsWith("[") && this.rendered.endsWith("]"));
        } else if (type.equals("application/xml")) {
            this.needSerializer = !this.rendered.startsWith("<") || !this.rendered.endsWith(">");
        }
    }

    @Override
    public String content() {
        return this.rendered;
    }

    @Override
    public boolean requireSerializer() {
        return this.needSerializer;
    }

    @Override
    public void setSerializedForm(String serialized) {
        this.rendered = serialized;
    }

    @Override
    public boolean mustBeChunked() {
        return false;
    }
}

