/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableXML
implements Renderable<Document> {
    private final Document document;
    private byte[] rendered;

    public RenderableXML(Document doc) {
        this.document = doc;
    }

    public RenderableXML(Element element) {
        this(element.getOwnerDocument());
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        if (this.rendered == null) {
            this.render();
        }
        return new ByteArrayInputStream(this.rendered);
    }

    private void render() throws RenderableException {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(this.document), new StreamResult(sw));
            this.rendered = sw.toString().getBytes(Charsets.UTF_8);
        }
        catch (Exception ex) {
            throw new RenderableException("Error converting XML document to String", ex);
        }
    }

    @Override
    public long length() {
        if (this.rendered == null) {
            try {
                this.render();
            }
            catch (RenderableException e) {
                LoggerFactory.getLogger(RenderableXML.class).warn("Cannot render XML object {}", (Object)this.document, (Object)e);
                return -1L;
            }
        }
        return this.rendered.length;
    }

    @Override
    public String mimetype() {
        return "application/xml";
    }

    @Override
    public Document content() {
        return this.document;
    }

    @Override
    public boolean requireSerializer() {
        return false;
    }

    @Override
    public void setSerializedForm(String serialized) {
    }

    @Override
    public boolean mustBeChunked() {
        return false;
    }
}

