/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import org.w3c.dom.Document;
import org.wisdom.api.bodies.NoHttpBody;
import org.wisdom.api.bodies.RenderableFile;
import org.wisdom.api.bodies.RenderableStream;
import org.wisdom.api.bodies.RenderableURL;
import org.wisdom.api.http.AsyncResult;
import org.wisdom.api.http.MimeTypes;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Result;

public abstract class Results {
    public static Result status(int statusCode) {
        return new Result(statusCode);
    }

    public static Result ok() {
        return Results.status(200).render(NoHttpBody.INSTANCE);
    }

    public static Result ok(Document document) {
        return Results.status(200).render(document).as("application/xml");
    }

    public static Result ok(JsonNode node) {
        return Results.status(200).render(node).as("application/json");
    }

    public static Result ok(Object object) {
        return Results.status(200).render(object);
    }

    public static Result ok(URL object) {
        return Results.status(200).render(new RenderableURL(object));
    }

    public static Result ok(InputStream object) {
        return Results.status(200).render(new RenderableStream(object));
    }

    public static Result ok(String object) {
        return Results.status(200).render(object).as("text/plain");
    }

    public static Result ok(String padding, JsonNode node) {
        return Results.status(200).render(padding, node);
    }

    public static Result ok(Result result) {
        return result.status(200);
    }

    public static Result notFound() {
        return Results.status(404).noContentIfNone();
    }

    public static Result notFound(String content) {
        return Results.status(404).render(content).as("text/plain");
    }

    public static Result notFound(Result result) {
        return result.status(404);
    }

    public static Result notFound(Renderable<?> renderable) {
        return Results.status(404).render(renderable);
    }

    public static Result forbidden() {
        return Results.status(403).noContentIfNone();
    }

    public static Result forbidden(Result result) {
        return result.status(403);
    }

    public static Result forbidden(String content) {
        return Results.status(403).render(content).as("text/plain");
    }

    public static Result unauthorized() {
        return Results.status(401).noContentIfNone();
    }

    public static Result unauthorized(Result result) {
        return result.status(401);
    }

    public static Result unauthorized(String content) {
        return Results.status(401).render(content).as("text/plain");
    }

    public static Result badRequest() {
        return Results.status(400).noContentIfNone();
    }

    public static Result badRequest(Result result) {
        return result.status(400);
    }

    public static Result badRequest(Object object) {
        return Results.status(400).render(object);
    }

    public static Result badRequest(String content) {
        return Results.status(400).render(content).as("text/plain");
    }

    public static Result noContent() {
        return Results.status(204).render(NoHttpBody.INSTANCE);
    }

    public static Result internalServerError() {
        return Results.status(500).noContentIfNone();
    }

    public static Result internalServerError(Throwable e) {
        return Results.status(500).render(e).as("application/json");
    }

    public static Result internalServerError(String content) {
        return Results.status(500).render(content).as("text/plain");
    }

    public static Result internalServerError(Renderable<?> renderable) {
        return Results.status(500).render(renderable);
    }

    public static Result redirect(String url) {
        return Results.status(303).with("Location", url).render(NoHttpBody.INSTANCE);
    }

    public static Result redirectTemporary(String url) {
        return Results.status(307).with("Location", url).render(NoHttpBody.INSTANCE);
    }

    public static Result html() {
        return Results.status(200).as("text/html");
    }

    public static Result json() {
        return Results.status(200).as("application/json");
    }

    public static Result xml() {
        return Results.status(200).as("application/xml");
    }

    public static Result todo() {
        return Results.status(501).json();
    }

    public static Result ok(File file, boolean attachment) {
        Preconditions.checkArgument((boolean)file.exists());
        Result result = Results.status(200).as(MimeTypes.getMimeTypeForFile(file)).with("Content-Length", Long.toString(file.length())).render(new RenderableFile(file));
        if (attachment) {
            result.with("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        }
        return result;
    }

    public static Result ok(File file) {
        return Results.ok(file, false);
    }

    public static AsyncResult async(Callable<Result> task) {
        return new AsyncResult(task);
    }
}

