/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.interception;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.interception.Filter;
import org.wisdom.api.interception.Interceptor;
import org.wisdom.api.router.Route;

public class RequestContext {
    private final Route route;
    private final List<Filter> chain;
    private final Map<Interceptor<?>, Object> interceptors;
    private Object[] parameters;
    private ListIterator<Filter> iterator;

    public RequestContext(Route route, List<Filter> chain, Map<Interceptor<?>, Object> interceptors, Object[] parameters, Filter endOfChainInvoker) {
        this.route = route;
        this.interceptors = interceptors;
        this.chain = new LinkedList<Filter>(chain);
        if (parameters != null) {
            this.parameters = Arrays.copyOf(parameters, parameters.length);
        }
        if (endOfChainInvoker == null) {
            endOfChainInvoker = new ActionInvoker();
        }
        this.chain.add(endOfChainInvoker);
    }

    public RequestContext setParameters(Object[] parameters) {
        this.parameters = parameters;
        return this;
    }

    <A> A getConfigurationForInterceptor(Interceptor<A> interceptor) {
        return (A)this.interceptors.get(interceptor);
    }

    public Result proceed() throws Exception {
        if (this.iterator == null) {
            this.iterator = this.chain.listIterator();
        }
        if (!this.iterator.hasNext()) {
            throw new IllegalStateException("Reached the end of the chain without result.");
        }
        Filter filter = this.iterator.next();
        return filter.call(this.route, this);
    }

    public Context context() {
        return Context.CONTEXT.get();
    }

    public Request request() {
        return this.context().request();
    }

    public Route route() {
        return this.route;
    }

    public Map<String, Object> data() {
        return this.request().data();
    }

    private class ActionInvoker
    implements Filter {
        private ActionInvoker() {
        }

        @Override
        public Result call(Route route, RequestContext context) throws InvocationTargetException, IllegalAccessException {
            if (RequestContext.this.route.isUnbound()) {
                return Results.notFound();
            }
            return (Result)RequestContext.this.route.getControllerMethod().invoke((Object)RequestContext.this.route.getControllerObject(), RequestContext.this.parameters);
        }

        @Override
        public Pattern uri() {
            return null;
        }

        @Override
        public int priority() {
            return -1;
        }
    }
}

