/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.model;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.wisdom.api.model.EntityFilter;
import org.wisdom.api.model.FluentTransaction;
import org.wisdom.api.model.HasBeenRollBackException;
import org.wisdom.api.model.Repository;
import org.wisdom.api.model.TransactionManager;

public interface Crud<T, I extends Serializable> {
    public static final String ENTITY_CLASS_PROPERTY = "entity.class";
    public static final String ENTITY_CLASSNAME_PROPERTY = "entity.classname";

    public Class<T> getEntityClass();

    public Class<I> getIdClass();

    public T delete(T var1);

    public void delete(I var1);

    public Iterable<T> delete(Iterable<T> var1);

    public T save(T var1);

    public Iterable<T> save(Iterable<T> var1);

    public T findOne(I var1);

    public T findOne(EntityFilter<T> var1);

    public boolean exists(I var1);

    public Iterable<T> findAll();

    public Iterable<T> findAll(Iterable<I> var1);

    public Iterable<T> findAll(EntityFilter<T> var1);

    public long count();

    public Repository getRepository();

    public void executeTransactionalBlock(Runnable var1) throws HasBeenRollBackException;

    public <A> A executeTransactionalBlock(Callable<A> var1) throws HasBeenRollBackException;

    public TransactionManager getTransactionManager();

    public <R> FluentTransaction<R> transaction();

    public <R> FluentTransaction.Intermediate transaction(Callable<R> var1);
}

