/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.router.parameters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.wisdom.api.annotations.Attribute;
import org.wisdom.api.annotations.BeanParameter;
import org.wisdom.api.annotations.Body;
import org.wisdom.api.annotations.DefaultValue;
import org.wisdom.api.annotations.FormParameter;
import org.wisdom.api.annotations.HttpParameter;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.PathParameter;
import org.wisdom.api.annotations.QueryParameter;
import org.wisdom.api.router.parameters.ParameterFactory;
import org.wisdom.api.router.parameters.Source;

public class ActionParameter {
    private static final Map<Class<? extends Annotation>, ParameterFactory> BINDINGS = new HashMap<Class<? extends Annotation>, ParameterFactory>();
    private final String name;
    private final Source source;
    private final Class<?> rawType;
    private final Type genericType;
    private String defaultValue;

    public static ActionParameter from(Member member, Annotation[] annotations, Class<?> rawType, Type genericType) {
        ActionParameter parameter = null;
        String defaultValue = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof DefaultValue) {
                defaultValue = ((DefaultValue)annotation).value();
                continue;
            }
            ParameterFactory factory = BINDINGS.get(annotation.annotationType());
            if (factory == null) continue;
            parameter = factory.build(annotation, rawType, genericType);
        }
        if (parameter == null) {
            throw new IllegalArgumentException("The member (Constructor or method) of " + member.getDeclaringClass().getName() + "." + member.getName() + " has a parameter without annotations indicating the injected data");
        }
        parameter.setDefaultValue(defaultValue);
        return parameter;
    }

    public ActionParameter(String name, Source source, Class<?> rawType) {
        this(name, source, rawType, null);
    }

    public ActionParameter(String name, Source source, Class<?> rawType, Type genericType) {
        this.name = name;
        this.source = source;
        this.rawType = rawType;
        this.genericType = genericType;
    }

    public void setDefaultValue(String dv) {
        this.defaultValue = dv;
    }

    public String getName() {
        return this.name;
    }

    public Source getSource() {
        return this.source;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    static {
        BINDINGS.put(Parameter.class, new ParameterFactory<Parameter>(){

            @Override
            public ActionParameter build(Parameter parameter, Class rawClass, Type genericType) {
                return new ActionParameter(parameter.value(), Source.PARAMETER, rawClass, genericType);
            }
        });
        BINDINGS.put(PathParameter.class, new ParameterFactory<PathParameter>(){

            @Override
            public ActionParameter build(PathParameter parameter, Class rawClass, Type genericType) {
                return new ActionParameter(parameter.value(), Source.PATH, rawClass, genericType);
            }
        });
        BINDINGS.put(QueryParameter.class, new ParameterFactory<QueryParameter>(){

            @Override
            public ActionParameter build(QueryParameter parameter, Class rawClass, Type genericType) {
                return new ActionParameter(parameter.value(), Source.QUERY, rawClass, genericType);
            }
        });
        BINDINGS.put(Attribute.class, new ParameterFactory<Attribute>(){

            @Override
            public ActionParameter build(Attribute parameter, Class rawClass, Type genericType) {
                return new ActionParameter(parameter.value(), Source.FORM, rawClass, genericType);
            }
        });
        BINDINGS.put(FormParameter.class, new ParameterFactory<FormParameter>(){

            @Override
            public ActionParameter build(FormParameter parameter, Class rawClass, Type genericType) {
                return new ActionParameter(parameter.value(), Source.FORM, rawClass, genericType);
            }
        });
        BINDINGS.put(Body.class, new ParameterFactory<Body>(){

            @Override
            public ActionParameter build(Body parameter, Class rawClass, Type genericType) {
                return new ActionParameter(null, Source.BODY, rawClass, genericType);
            }
        });
        BINDINGS.put(HttpParameter.class, new ParameterFactory<HttpParameter>(){

            @Override
            public ActionParameter build(HttpParameter parameter, Class rawClass, Type genericType) {
                return new ActionParameter(parameter.value(), Source.HTTP, rawClass, genericType);
            }
        });
        BINDINGS.put(BeanParameter.class, new ParameterFactory<BeanParameter>(){

            @Override
            public ActionParameter build(BeanParameter parameter, Class rawClass, Type genericType) {
                return new ActionParameter(null, Source.BEAN, rawClass, genericType);
            }
        });
    }
}

