/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public final class KnownMimeTypes {
    public static final Multimap<String, String> EXTENSIONS_FOR_MIME = TreeMultimap.create();
    public static final Map<String, String> EXTENSIONS = new TreeMap<String, String>();
    public static final Set<String> COMPRESSED_MIME;

    private KnownMimeTypes() {
    }

    private static void addMimeToCompressedWithExtension(String extension) {
        String mime = EXTENSIONS.get(extension);
        if (mime != null && !COMPRESSED_MIME.contains(mime)) {
            COMPRESSED_MIME.add(mime);
        }
    }

    private static void addMimeGroups(String ... groups) {
        for (String mimeType : EXTENSIONS.values()) {
            for (String group : groups) {
                if (!mimeType.startsWith(group) || COMPRESSED_MIME.contains(mimeType)) continue;
                COMPRESSED_MIME.add(mimeType);
            }
        }
    }

    public static String getMimeTypeByExtension(String extension) {
        return EXTENSIONS.get(extension);
    }

    public static MediaType getMediaTypeByExtension(String extension) {
        String input = EXTENSIONS.get(extension);
        if (input == null) {
            return null;
        }
        return MediaType.parse((String)input);
    }

    static {
        URL url = KnownMimeTypes.class.getClassLoader().getResource("mimes/known.mime.types");
        Preconditions.checkNotNull((Object)url, (Object)"Cannot find the internal known mime types");
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                String extensions = properties.getProperty(key);
                Iterable listOfExtensions = Splitter.on((String)" ").trimResults().split((CharSequence)extensions);
                EXTENSIONS_FOR_MIME.putAll((Object)key, listOfExtensions);
                for (String ext : listOfExtensions) {
                    EXTENSIONS.put(ext, key);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load the internal known mime types", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        COMPRESSED_MIME = new HashSet<String>();
        KnownMimeTypes.addMimeToCompressedWithExtension("bz2");
        KnownMimeTypes.addMimeToCompressedWithExtension("gz");
        KnownMimeTypes.addMimeToCompressedWithExtension("gzip");
        KnownMimeTypes.addMimeToCompressedWithExtension("lzma");
        KnownMimeTypes.addMimeToCompressedWithExtension("z");
        KnownMimeTypes.addMimeToCompressedWithExtension("7z");
        KnownMimeTypes.addMimeToCompressedWithExtension("s7z");
        KnownMimeTypes.addMimeToCompressedWithExtension("ace");
        KnownMimeTypes.addMimeToCompressedWithExtension("alz");
        KnownMimeTypes.addMimeToCompressedWithExtension("arc");
        KnownMimeTypes.addMimeToCompressedWithExtension("arj");
        KnownMimeTypes.addMimeToCompressedWithExtension("cab");
        KnownMimeTypes.addMimeToCompressedWithExtension("cpt");
        KnownMimeTypes.addMimeToCompressedWithExtension("dar");
        KnownMimeTypes.addMimeToCompressedWithExtension("dmg");
        KnownMimeTypes.addMimeToCompressedWithExtension("ice");
        KnownMimeTypes.addMimeToCompressedWithExtension("lha");
        KnownMimeTypes.addMimeToCompressedWithExtension("lzx");
        KnownMimeTypes.addMimeToCompressedWithExtension("rar");
        KnownMimeTypes.addMimeToCompressedWithExtension("sit");
        KnownMimeTypes.addMimeToCompressedWithExtension("sitx");
        KnownMimeTypes.addMimeToCompressedWithExtension("tar");
        KnownMimeTypes.addMimeToCompressedWithExtension("tgz");
        KnownMimeTypes.addMimeToCompressedWithExtension("zip");
        KnownMimeTypes.addMimeToCompressedWithExtension("zoo");
        KnownMimeTypes.addMimeGroups("video/", "image/", "audio/");
    }
}

