/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.Controller;
import org.wisdom.api.DefaultController;
import org.wisdom.api.asset.Asset;
import org.wisdom.api.asset.AssetProvider;
import org.wisdom.api.asset.DefaultAsset;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.RouteBuilder;
import org.wisdom.resources.CacheUtils;

@Component(immediate=true)
@Provides
public class AssetController
extends DefaultController
implements AssetProvider,
Pojo {
    InstanceManager __IM;
    public static final Logger LOGGER = LoggerFactory.getLogger(AssetController.class);
    private boolean __Fdirectory;
    private final File directory;
    private boolean __Fcontext;
    @Context
    private BundleContext context;
    private boolean __FmanageAssetsFromBundles;
    private final boolean manageAssetsFromBundles;
    private boolean __FpathInBundles;
    private final String pathInBundles;
    private boolean __Froot;
    private final String root;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fcrypto;
    @Requires
    Crypto crypto;
    boolean __McomputeRoot$java_lang_String;
    boolean __McomputePathInBundle$java_lang_String;
    boolean __Mroutes;
    boolean __Mserve;
    boolean __MgetAssetFromBundle$java_lang_String;
    boolean __MgetAssetFromFS$java_lang_String;
    boolean __Massets;
    boolean __MassetAt$java_lang_String;

    File __getdirectory() {
        if (!this.__Fdirectory) {
            return this.directory;
        }
        return (File)this.__IM.onGet((Object)this, "directory");
    }

    void __setdirectory(File file) {
        if (!this.__Fdirectory) {
            this.directory = file;
            return;
        }
        this.__IM.onSet((Object)this, "directory", (Object)file);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    boolean __getmanageAssetsFromBundles() {
        if (!this.__FmanageAssetsFromBundles) {
            return this.manageAssetsFromBundles;
        }
        Object object = this.__IM.onGet((Object)this, "manageAssetsFromBundles");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setmanageAssetsFromBundles(boolean bl) {
        if (!this.__FmanageAssetsFromBundles) {
            this.manageAssetsFromBundles = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "manageAssetsFromBundles", (Object)bl2);
    }

    String __getpathInBundles() {
        if (!this.__FpathInBundles) {
            return this.pathInBundles;
        }
        return (String)this.__IM.onGet((Object)this, "pathInBundles");
    }

    void __setpathInBundles(String string) {
        if (!this.__FpathInBundles) {
            this.pathInBundles = string;
            return;
        }
        this.__IM.onSet((Object)this, "pathInBundles", (Object)string);
    }

    String __getroot() {
        if (!this.__Froot) {
            return this.root;
        }
        return (String)this.__IM.onGet((Object)this, "root");
    }

    void __setroot(String string) {
        if (!this.__Froot) {
            this.root = string;
            return;
        }
        this.__IM.onSet((Object)this, "root", (Object)string);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Crypto __getcrypto() {
        if (!this.__Fcrypto) {
            return this.crypto;
        }
        return (Crypto)this.__IM.onGet((Object)this, "crypto");
    }

    void __setcrypto(Crypto crypto) {
        if (!this.__Fcrypto) {
            this.crypto = crypto;
            return;
        }
        this.__IM.onSet((Object)this, "crypto", (Object)crypto);
    }

    public AssetController(ApplicationConfiguration configuration, Crypto crypto, BundleContext bc, String path, boolean manageAssetsFromBundles, String pathInBundles, String url) {
        this(null, configuration, crypto, bc, path, manageAssetsFromBundles, pathInBundles, url);
    }

    private AssetController(InstanceManager _manager, ApplicationConfiguration configuration, Crypto crypto, BundleContext bc, String path, boolean manageAssetsFromBundles, String pathInBundles, String url) {
        this._setInstanceManager(_manager);
        this.__setconfiguration(configuration);
        this.__setcrypto(crypto);
        this.__setcontext(bc);
        if (!Strings.isNullOrEmpty((String)path)) {
            this.__setdirectory(new File(configuration.getBaseDir(), path));
        } else {
            this.__setdirectory(null);
        }
        this.__setmanageAssetsFromBundles(manageAssetsFromBundles);
        this.__setpathInBundles(this.computePathInBundle(pathInBundles));
        this.__setroot(this.computeRoot(url));
    }

    public AssetController(@Property(name="path", value="") String path, @Property(name="manageAssetsFromBundles", value="false") boolean manageAssetsFromBundles, @Property(name="pathInBundles", value="/assets/") String pathInBundles, @Property(name="url", value="/assets") String url) {
        this(null, path, manageAssetsFromBundles, pathInBundles, url);
    }

    private AssetController(InstanceManager _manager, String path, boolean manageAssetsFromBundles, String pathInBundles, String url) {
        this._setInstanceManager(_manager);
        if (!Strings.isNullOrEmpty((String)path)) {
            this.__setdirectory(new File(this.__getconfiguration().getBaseDir(), path));
        } else {
            this.__setdirectory(null);
        }
        this.__setmanageAssetsFromBundles(manageAssetsFromBundles);
        this.__setpathInBundles(this.computePathInBundle(pathInBundles));
        this.__setroot(this.computeRoot(url));
        if (manageAssetsFromBundles) {
            LOGGER.info("Serving assets from bundles ({}) on {}", (Object)pathInBundles, (Object)this.__getroot());
        }
        LOGGER.info("Serving assets from file system ({}) on {}", (Object)path, (Object)this.__getroot());
    }

    private String computeRoot(String url) {
        String string;
        if (!this.__McomputeRoot$java_lang_String) {
            return this.__M_computeRoot(url);
        }
        try {
            this.__IM.onEntry((Object)this, "computeRoot$java_lang_String", new Object[]{url});
            string = this.__M_computeRoot(url);
            this.__IM.onExit((Object)this, "computeRoot$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "computeRoot$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_computeRoot(String url) {
        if (url != null) {
            if (!url.startsWith("/")) {
                throw new IllegalArgumentException("The `url` property must start with `/`");
            }
            return url;
        }
        return "/assets";
    }

    protected String computePathInBundle(String pathInBundles) {
        String string;
        if (!this.__McomputePathInBundle$java_lang_String) {
            return this.__M_computePathInBundle(pathInBundles);
        }
        try {
            this.__IM.onEntry((Object)this, "computePathInBundle$java_lang_String", new Object[]{pathInBundles});
            string = this.__M_computePathInBundle(pathInBundles);
            this.__IM.onExit((Object)this, "computePathInBundle$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "computePathInBundle$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_computePathInBundle(String pathInBundles) {
        if (this.__getmanageAssetsFromBundles() && !Strings.isNullOrEmpty((String)pathInBundles)) {
            if (!pathInBundles.startsWith("/") || !pathInBundles.endsWith("/")) {
                throw new IllegalArgumentException("The `pathInBundles` property must start and end with `/`");
            }
            return pathInBundles;
        }
        return "/assets/";
    }

    public List<Route> routes() {
        List<Route> list;
        if (!this.__Mroutes) {
            return this.__M_routes();
        }
        try {
            this.__IM.onEntry((Object)this, "routes", new Object[0]);
            list = this.__M_routes();
            this.__IM.onExit((Object)this, "routes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "routes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Route> __M_routes() {
        return ImmutableList.of((Object)new RouteBuilder().route(HttpMethod.GET).on(this.__getroot() + "/{path+}").to((Controller)this, "serve"));
    }

    public Result serve() {
        Result result;
        if (!this.__Mserve) {
            return this.__M_serve();
        }
        try {
            this.__IM.onEntry((Object)this, "serve", new Object[0]);
            result = this.__M_serve();
            this.__IM.onExit((Object)this, "serve", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serve", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_serve() {
        Object asset;
        String path = this.context().parameterFromPath("path");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((asset = this.getAssetFromFS(path)) == null && this.__getmanageAssetsFromBundles()) {
            asset = this.getAssetFromBundle(path);
        }
        if (asset != null) {
            return CacheUtils.fromAsset(this.context(), asset, this.__getconfiguration());
        }
        return AssetController.notFound();
    }

    private Asset<URL> getAssetFromBundle(String path) {
        Asset<URL> asset;
        if (!this.__MgetAssetFromBundle$java_lang_String) {
            return this.__M_getAssetFromBundle(path);
        }
        try {
            this.__IM.onEntry((Object)this, "getAssetFromBundle$java_lang_String", new Object[]{path});
            asset = this.__M_getAssetFromBundle(path);
            this.__IM.onExit((Object)this, "getAssetFromBundle$java_lang_String", asset);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAssetFromBundle$java_lang_String", throwable);
            throw throwable;
        }
        return asset;
    }

    private Asset<URL> __M_getAssetFromBundle(String path) {
        Bundle[] bundles = this.__getcontext().getBundles();
        for (int i = 1; i < bundles.length; ++i) {
            URL url = bundles[i].getResource(this.__getpathInBundles() + path);
            if (url == null) continue;
            return new DefaultAsset(this.__getroot() + "/" + path, (Object)url, bundles[i].getSymbolicName(), bundles[i].getLastModified(), CacheUtils.computeEtag(bundles[i].getLastModified(), this.__getconfiguration(), this.__getcrypto()));
        }
        return null;
    }

    private Asset<File> getAssetFromFS(String path) {
        Asset<File> asset;
        if (!this.__MgetAssetFromFS$java_lang_String) {
            return this.__M_getAssetFromFS(path);
        }
        try {
            this.__IM.onEntry((Object)this, "getAssetFromFS$java_lang_String", new Object[]{path});
            asset = this.__M_getAssetFromFS(path);
            this.__IM.onExit((Object)this, "getAssetFromFS$java_lang_String", asset);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAssetFromFS$java_lang_String", throwable);
            throw throwable;
        }
        return asset;
    }

    private Asset<File> __M_getAssetFromFS(String path) {
        if (this.__getdirectory() == null) {
            return null;
        }
        File file = new File(this.__getdirectory(), path);
        if (!file.exists()) {
            return null;
        }
        return new DefaultAsset(this.__getroot() + "/" + path, (Object)file, file.getAbsolutePath(), file.lastModified(), CacheUtils.computeEtag(file.lastModified(), this.__getconfiguration(), this.__getcrypto()));
    }

    public Collection<Asset<?>> assets() {
        Collection<Asset<?>> collection;
        if (!this.__Massets) {
            return this.__M_assets();
        }
        try {
            this.__IM.onEntry((Object)this, "assets", new Object[0]);
            collection = this.__M_assets();
            this.__IM.onExit((Object)this, "assets", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assets", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<Asset<?>> __M_assets() {
        HashMap<String, DefaultAsset> map = new HashMap<String, DefaultAsset>();
        if (this.__getdirectory() != null && this.__getdirectory().isDirectory()) {
            Collection files = FileUtils.listFiles((File)this.__getdirectory(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File file : files) {
                if (file.getName().startsWith(".") || file.getName().startsWith(".")) continue;
                String path = this.__getroot() + file.getAbsolutePath().substring(this.__getdirectory().getAbsolutePath().length()).replace("\\", "/");
                map.put(path, new DefaultAsset(path, (Object)file, file.getAbsolutePath(), file.lastModified(), null));
            }
        }
        if (!this.__getmanageAssetsFromBundles()) {
            return map.values();
        }
        Bundle[] bundles = this.__getcontext().getBundles();
        for (int i = 1; i < bundles.length; ++i) {
            URL root = bundles[i].getEntry(this.__getpathInBundles().substring(0, this.__getpathInBundles().length() - 1));
            Enumeration urls = bundles[i].findEntries(this.__getpathInBundles(), "*", true);
            if (urls == null) continue;
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                String path = url.toExternalForm().substring(root.toExternalForm().length());
                path = path.startsWith("/") ? this.__getroot() + path : this.__getroot() + "/" + path;
                if (map.containsKey(path)) continue;
                map.put(path, new DefaultAsset(path, (Object)url, url.toExternalForm(), bundles[i].getLastModified(), null));
            }
        }
        return map.values();
    }

    public Asset<?> assetAt(String path) {
        Asset<?> asset;
        if (!this.__MassetAt$java_lang_String) {
            return this.__M_assetAt(path);
        }
        try {
            this.__IM.onEntry((Object)this, "assetAt$java_lang_String", new Object[]{path});
            asset = this.__M_assetAt(path);
            this.__IM.onExit((Object)this, "assetAt$java_lang_String", asset);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assetAt$java_lang_String", throwable);
            throw throwable;
        }
        return asset;
    }

    private Asset<?> __M_assetAt(String path) {
        Object asset = this.getAssetFromFS(path);
        if (asset == null) {
            asset = this.getAssetFromBundle(path);
        }
        return asset;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("crypto")) {
                this.__Fcrypto = true;
            }
            if (set.contains("directory")) {
                this.__Fdirectory = true;
            }
            if (set.contains("manageAssetsFromBundles")) {
                this.__FmanageAssetsFromBundles = true;
            }
            if (set.contains("pathInBundles")) {
                this.__FpathInBundles = true;
            }
            if (set.contains("root")) {
                this.__Froot = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("computeRoot$java_lang_String")) {
                this.__McomputeRoot$java_lang_String = true;
            }
            if (set.contains("computePathInBundle$java_lang_String")) {
                this.__McomputePathInBundle$java_lang_String = true;
            }
            if (set.contains("routes")) {
                this.__Mroutes = true;
            }
            if (set.contains("serve")) {
                this.__Mserve = true;
            }
            if (set.contains("getAssetFromBundle$java_lang_String")) {
                this.__MgetAssetFromBundle$java_lang_String = true;
            }
            if (set.contains("getAssetFromFS$java_lang_String")) {
                this.__MgetAssetFromFS$java_lang_String = true;
            }
            if (set.contains("assets")) {
                this.__Massets = true;
            }
            if (set.contains("assetAt$java_lang_String")) {
                this.__MassetAt$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public AssetController(InstanceManager instanceManager) {
        this._setInstanceManager(instanceManager);
    }
}

