/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.asset.Asset;
import org.wisdom.api.asset.AssetProvider;
import org.wisdom.api.asset.Assets;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Negotiation;
import org.wisdom.api.http.Result;
import org.wisdom.api.templates.Template;

@Component
@Provides
@Instantiate
public class AssetsSingleton
extends DefaultController
implements Assets,
Pojo {
    InstanceManager __IM;
    boolean __M1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset;
    boolean __M1___compare$java_lang_Object$java_lang_Object;
    private boolean __Fcache;
    private Collection<Asset<?>> cache;
    private boolean __Fproviders;
    @Requires(optional=true)
    AssetProvider[] providers;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Ftemplate;
    @Requires(filter="(name=assets/list)")
    Template template;
    boolean __Mindex;
    boolean __Mall;
    boolean __MassetAt$java_lang_String;
    boolean __Massets;
    boolean __Massets$boolean;

    Collection __getcache() {
        if (!this.__Fcache) {
            return this.cache;
        }
        return (Collection)this.__IM.onGet((Object)this, "cache");
    }

    void __setcache(Collection collection) {
        if (!this.__Fcache) {
            this.cache = collection;
            return;
        }
        this.__IM.onSet((Object)this, "cache", (Object)collection);
    }

    AssetProvider[] __getproviders() {
        if (!this.__Fproviders) {
            return this.providers;
        }
        return (AssetProvider[])this.__IM.onGet((Object)this, "providers");
    }

    void __setproviders(AssetProvider[] assetProviderArray) {
        if (!this.__Fproviders) {
            this.providers = assetProviderArray;
            return;
        }
        this.__IM.onSet((Object)this, "providers", (Object)assetProviderArray);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Template __gettemplate() {
        if (!this.__Ftemplate) {
            return this.template;
        }
        return (Template)this.__IM.onGet((Object)this, "template");
    }

    void __settemplate(Template template) {
        if (!this.__Ftemplate) {
            this.template = template;
            return;
        }
        this.__IM.onSet((Object)this, "template", (Object)template);
    }

    public AssetsSingleton() {
        this(null);
    }

    private AssetsSingleton(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcache(new ArrayList());
    }

    @Route(uri="/assets", method=HttpMethod.GET)
    public Result index() {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() {
        if (this.__getconfiguration().isProd()) {
            return AssetsSingleton.badRequest((String)"Sorry, no asset dump in PROD mode.");
        }
        if (this.__getcache().isEmpty() || "no-cache".equalsIgnoreCase(this.context().header("Cache-Control"))) {
            this.all();
        }
        return Negotiation.accept((Map)ImmutableMap.of((Object)"text/html", (Object)AssetsSingleton.ok((Object)this.render(this.__gettemplate(), new Object[]{"assets", this.__getcache()})), (Object)"application/json", (Object)AssetsSingleton.ok((Object)this.__getcache()).json()));
    }

    private List<Asset<?>> all() {
        List<Asset<?>> list;
        if (!this.__Mall) {
            return this.__M_all();
        }
        try {
            this.__IM.onEntry((Object)this, "all", new Object[0]);
            list = this.__M_all();
            this.__IM.onExit((Object)this, "all", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "all", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Asset<?>> __M_all() {
        ArrayList assets = new ArrayList();
        for (AssetProvider p : this.__getproviders()) {
            assets.addAll(p.assets());
        }
        Collections.sort(assets, new Comparator<Asset<?>>(){

            @Override
            public int compare(Asset<?> asset, Asset<?> asset2) {
                int n;
                if (!AssetsSingleton.this.__M1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset) {
                    return this.__M_compare(asset, asset2);
                }
                try {
                    AssetsSingleton.this.__IM.onEntry((Object)this, "1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset", new Object[]{asset, asset2});
                    n = this.__M_compare(asset, asset2);
                    AssetsSingleton.this.__IM.onExit((Object)this, "1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset", (Object)new Integer(n));
                }
                catch (Throwable throwable) {
                    AssetsSingleton.this.__IM.onError((Object)this, "1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset", throwable);
                    throw throwable;
                }
                return n;
            }

            private int __M_compare(Asset<?> o1, Asset<?> o2) {
                return o1.getPath().compareTo(o2.getPath());
            }

            private int __M_compare(Object object, Object object2) {
                return this.compare((Asset)object, (Asset)object2);
            }
        });
        this.__setcache(assets);
        return assets;
    }

    public Asset assetAt(String path) {
        Asset asset;
        if (!this.__MassetAt$java_lang_String) {
            return this.__M_assetAt(path);
        }
        try {
            this.__IM.onEntry((Object)this, "assetAt$java_lang_String", new Object[]{path});
            asset = this.__M_assetAt(path);
            this.__IM.onExit((Object)this, "assetAt$java_lang_String", (Object)asset);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assetAt$java_lang_String", throwable);
            throw throwable;
        }
        return asset;
    }

    private Asset __M_assetAt(String path) {
        for (AssetProvider provider : this.__getproviders()) {
            Asset asset = provider.assetAt(path);
            if (asset == null) continue;
            return asset;
        }
        return null;
    }

    public Collection<Asset<?>> assets() {
        Collection<Asset<?>> collection;
        if (!this.__Massets) {
            return this.__M_assets();
        }
        try {
            this.__IM.onEntry((Object)this, "assets", new Object[0]);
            collection = this.__M_assets();
            this.__IM.onExit((Object)this, "assets", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assets", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<Asset<?>> __M_assets() {
        return new ArrayList(this.all());
    }

    public Collection<Asset<?>> assets(boolean useCache) {
        Collection<Asset<?>> collection;
        if (!this.__Massets$boolean) {
            return this.__M_assets(useCache);
        }
        try {
            this.__IM.onEntry((Object)this, "assets$boolean", new Object[]{new Boolean(useCache)});
            collection = this.__M_assets(useCache);
            this.__IM.onExit((Object)this, "assets$boolean", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assets$boolean", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<Asset<?>> __M_assets(boolean useCache) {
        if (useCache && !this.__getcache().isEmpty()) {
            return new ArrayList(this.__getcache());
        }
        return this.assets();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("cache")) {
                this.__Fcache = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("providers")) {
                this.__Fproviders = true;
            }
            if (set.contains("template")) {
                this.__Ftemplate = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset")) {
                this.__M1___compare$org_wisdom_api_asset_Asset$org_wisdom_api_asset_Asset = true;
            }
            if (set.contains("1___compare$java_lang_Object$java_lang_Object")) {
                this.__M1___compare$java_lang_Object$java_lang_Object = true;
            }
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("all")) {
                this.__Mall = true;
            }
            if (set.contains("assetAt$java_lang_String")) {
                this.__MassetAt$java_lang_String = true;
            }
            if (set.contains("assets")) {
                this.__Massets = true;
            }
            if (set.contains("assets$boolean")) {
                this.__Massets$boolean = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

