/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.resources.CacheUtils;
import org.wisdom.resources.WebJarLib;

class FileWebJarLib
extends WebJarLib {
    public final File root;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileWebJarLib.class);
    public final String source;
    private Map<String, File> index = new TreeMap<String, File>();

    FileWebJarLib(String name, String version, File root) {
        super(name, version);
        this.root = root;
        this.source = null;
        this.index();
    }

    FileWebJarLib(String name, String version, File root, String source) {
        super(name, version);
        this.root = root;
        this.source = source;
        this.index();
    }

    @Override
    public Result get(String path, Context context, ApplicationConfiguration configuration, Crypto crypto) {
        File file = new File(this.root, path);
        if (!file.isFile()) {
            return Results.notFound();
        }
        return CacheUtils.fromFile(file, context, configuration, crypto);
    }

    @Override
    public Object get(String path) {
        File file = new File(this.root, path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    public long lastModified() {
        return this.root.lastModified();
    }

    @Override
    public Collection<String> names() {
        return this.index.keySet();
    }

    private void index() {
        File base = this.root;
        if (this.source != null) {
            String module = this.source.substring(0, this.source.lastIndexOf(45));
            File file = new File(this.root, module);
            if (file.isDirectory()) {
                LOGGER.debug("Indexing files for WebJar library {}-{} / {}", new Object[]{this.name, this.version, this.source});
                base = file;
            } else {
                LOGGER.debug("Indexing files for WebJar library {}-{}", (Object)this.name, (Object)this.version);
            }
        } else {
            LOGGER.debug("Indexing files for WebJar library {}-{}", (Object)this.name, (Object)this.version);
        }
        for (File file : FileUtils.listFiles((File)base, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            if (file.isDirectory()) continue;
            String path = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            path = path.replace("\\", "/");
            this.index.put(path, file);
        }
    }

    @Override
    public String toString() {
        if (this.source != null) {
            return super.toString() + '-' + this.source;
        }
        return super.toString();
    }
}

