/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.bodyparsers;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.BodyParser;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.FileItem;
import org.wisdom.content.converters.ReflectionHelper;

@Component
@Provides
@Instantiate
public class BodyParserForm
implements BodyParser,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyParser.class);
    private static final String ERROR_KEY = "Error parsing incoming form data for key ";
    private static final String ERROR_AND = " and value ";
    private boolean __Fconverters;
    @Requires
    ParameterFactories converters;
    boolean __Minvoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type;
    boolean __Minvoke$org_wisdom_api_http_Context$java_lang_Class;
    boolean __Minvoke$byte__$java_lang_Class;
    boolean __MgetContentTypes;

    ParameterFactories __getconverters() {
        if (!this.__Fconverters) {
            return this.converters;
        }
        return (ParameterFactories)this.__IM.onGet((Object)this, "converters");
    }

    void __setconverters(ParameterFactories parameterFactories) {
        if (!this.__Fconverters) {
            this.converters = parameterFactories;
            return;
        }
        this.__IM.onSet((Object)this, "converters", (Object)parameterFactories);
    }

    public BodyParserForm() {
        this(null);
    }

    private BodyParserForm(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public <T> T invoke(Context context, Class<T> classOfT, Type genericType) {
        T t;
        if (!this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type) {
            return this.__M_invoke(context, classOfT, genericType);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type", new Object[]{context, classOfT, genericType});
            t = this.__M_invoke(context, classOfT, genericType);
            this.__IM.onExit((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(Context context, Class<T> classOfT, Type genericType) {
        Object value;
        ReflectionHelper.Property property;
        T t;
        try {
            t = classOfT.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create a new instance of {}", classOfT, (Object)e);
            return null;
        }
        Map<String, ReflectionHelper.Property> properties = ReflectionHelper.getProperties(classOfT, genericType);
        for (Map.Entry ent : context.parameters().entrySet()) {
            try {
                ReflectionHelper.Property property2 = properties.get(ent.getKey());
                if (property2 == null) continue;
                Object value2 = this.__getconverters().convertValues((Collection)ent.getValue(), property2.getClassOfProperty(), property2.getGenericTypeOfProperty(), null);
                property2.set(t, value2);
            }
            catch (Exception e) {
                LOGGER.warn(ERROR_KEY + (String)ent.getKey() + ERROR_AND + ent.getValue(), (Throwable)e);
            }
        }
        Map fromPath = context.route().getPathParametersEncoded(context.request().uri());
        for (Map.Entry ent : fromPath.entrySet()) {
            try {
                property = properties.get(ent.getKey());
                if (property == null) continue;
                value = this.__getconverters().convertValue((String)ent.getValue(), property.getClassOfProperty(), property.getGenericTypeOfProperty(), null);
                property.set(t, value);
            }
            catch (Exception e) {
                LOGGER.debug(ERROR_KEY + (String)ent.getKey() + ERROR_AND + (String)ent.getValue(), (Throwable)e);
            }
        }
        if (context.form() == null || context.form().isEmpty()) {
            return t;
        }
        for (Map.Entry ent : context.form().entrySet()) {
            try {
                property = properties.get(ent.getKey());
                if (property == null) continue;
                value = this.__getconverters().convertValues((Collection)ent.getValue(), property.getClassOfProperty(), property.getGenericTypeOfProperty(), null);
                property.set(t, value);
            }
            catch (Exception e) {
                LOGGER.warn(ERROR_KEY + (String)ent.getKey() + ERROR_AND + ent.getValue(), (Throwable)e);
            }
        }
        if (context.files() == null || context.files().isEmpty()) {
            return t;
        }
        for (FileItem item : context.files()) {
            try {
                property = properties.get(item.field());
                if (property == null) continue;
                if (InputStream.class.isAssignableFrom(property.getClassOfProperty())) {
                    property.set(t, item.stream());
                    continue;
                }
                if (FileItem.class.isAssignableFrom(property.getClassOfProperty())) {
                    property.set(t, item);
                    continue;
                }
                if (!property.getClassOfProperty().isArray() || !property.getClassOfProperty().getComponentType().equals(Byte.TYPE)) continue;
                property.set(t, item.bytes());
            }
            catch (Exception e) {
                LOGGER.warn(ERROR_KEY + item.field() + ERROR_AND + item, (Throwable)e);
            }
        }
        return t;
    }

    public <T> T invoke(Context context, Class<T> classOfT) {
        T t;
        if (!this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class) {
            return this.__M_invoke(context, classOfT);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", new Object[]{context, classOfT});
            t = this.__M_invoke(context, classOfT);
            this.__IM.onExit((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(Context context, Class<T> classOfT) {
        return this.invoke(context, classOfT, null);
    }

    public <T> T invoke(byte[] bytes, Class<T> classOfT) {
        T t;
        if (!this.__Minvoke$byte__$java_lang_Class) {
            return this.__M_invoke(bytes, classOfT);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$byte__$java_lang_Class", new Object[]{bytes, classOfT});
            t = this.__M_invoke(bytes, classOfT);
            this.__IM.onExit((Object)this, "invoke$byte__$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$byte__$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(byte[] bytes, Class<T> classOfT) {
        throw new UnsupportedOperationException("Cannot bind a raw byte[] to a form object");
    }

    public List<String> getContentTypes() {
        List<String> list;
        if (!this.__MgetContentTypes) {
            return this.__M_getContentTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getContentTypes", new Object[0]);
            list = this.__M_getContentTypes();
            this.__IM.onExit((Object)this, "getContentTypes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentTypes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getContentTypes() {
        return ImmutableList.of((Object)"application/x-www-form-urlencoded", (Object)"multipart/form-data");
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("converters")) {
            this.__Fconverters = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("invoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type")) {
                this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class$java_lang_reflect_Type = true;
            }
            if (set.contains("invoke$org_wisdom_api_http_Context$java_lang_Class")) {
                this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class = true;
            }
            if (set.contains("invoke$byte__$java_lang_Class")) {
                this.__Minvoke$byte__$java_lang_Class = true;
            }
            if (set.contains("getContentTypes")) {
                this.__MgetContentTypes = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

