/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.ParameterConverter;

public final class ConstructorBasedConverter<T>
implements ParameterConverter<T> {
    private final Constructor<T> constructor;
    private final Class<T> clazz;

    private ConstructorBasedConverter(Class<T> clazz, Constructor<T> constructor) {
        this.constructor = constructor;
        this.clazz = clazz;
    }

    public static <T> ConstructorBasedConverter<T> getIfEligible(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ConstructorBasedConverter<T>(clazz, constructor);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public T fromString(String input) throws IllegalArgumentException {
        try {
            return this.constructor.newInstance(input);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot create an instance of {} from \"{}\"", new Object[]{this.constructor.getDeclaringClass().getName(), input, e});
            if (e.getCause() != null) {
                throw new IllegalArgumentException(e.getCause());
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<T> getType() {
        return this.clazz;
    }
}

