/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.wisdom.content.converters.ClassTypePair;
import org.wisdom.content.converters.EraserVisitor;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Map<String, Property> getProperties(Class clazz, Type genericType) {
        TreeMap<String, Property> map = new TreeMap<String, Property>(String.CASE_INSENSITIVE_ORDER);
        Method[] methods = clazz.getMethods();
        for (Method method : methods) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            String name = method.getName().substring("set".length());
            Property property = (Property)map.get(name);
            if (property == null) {
                property = new Property();
                map.put(name, property);
            }
            property.setter(method);
        }
        for (Field field : ReflectionHelper.getAllFields(clazz)) {
            String name = field.getName();
            Property property = (Property)map.get(name);
            if (property != null) continue;
            property = new Property();
            property.field(field);
            map.put(name, property);
        }
        return map;
    }

    public static List<ClassTypePair> getTypeArgumentAndClass(Type type) throws IllegalArgumentException {
        Type[] types = ReflectionHelper.getTypeArguments(type);
        if (types == null) {
            return Collections.emptyList();
        }
        ArrayList<ClassTypePair> list = new ArrayList<ClassTypePair>();
        for (Type t : types) {
            list.add(new ClassTypePair(ReflectionHelper.erasure(t), t));
        }
        return list;
    }

    public static <T> Class<T> erasure(Type type) {
        return EraserVisitor.ERASER.visit(type);
    }

    public static Type[] getTypeArguments(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public static String getPrimitiveDefault(Class type) {
        if (type == Boolean.class) {
            return "false";
        }
        if (type == Character.class) {
            return Character.toString('\u0000');
        }
        return "0";
    }

    public static List<Field> getAllFields(Class<?> cls) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static class Property {
        private Field field;
        private Class classOfProperty;
        private Type genericOfProperty;
        private Method setter;

        private Property() {
        }

        public void set(Object target, Object value) throws InvocationTargetException, IllegalAccessException {
            if (this.setter != null) {
                this.setter.invoke(target, value);
            } else {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                this.field.set(target, value);
            }
        }

        public Class<?> getClassOfProperty() {
            return this.classOfProperty;
        }

        public Type getGenericTypeOfProperty() {
            return this.genericOfProperty;
        }

        public void setter(Method setter) {
            this.setter = setter;
            this.classOfProperty = setter.getParameterTypes()[0];
            this.genericOfProperty = setter.getGenericParameterTypes()[0];
        }

        public void field(Field field) {
            this.field = field;
            this.classOfProperty = field.getType();
            this.genericOfProperty = field.getGenericType();
        }
    }
}

