/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.engines;

import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.BodyParser;
import org.wisdom.api.content.ContentEngine;
import org.wisdom.api.content.ContentSerializer;

@Component
@Provides
@Instantiate(name="ContentEngine")
public class Engine
implements ContentEngine,
Pojo {
    InstanceManager __IM;
    private boolean __Fparsers;
    @Requires(specification=BodyParser.class, optional=true)
    List<BodyParser> parsers;
    private boolean __Fserializers;
    @Requires(specification=ContentSerializer.class, optional=true)
    List<ContentSerializer> serializers;
    boolean __MgetBodyParserEngineForContentType$java_lang_String;
    boolean __MgetContentSerializerForContentType$java_lang_String;
    boolean __MgetBestSerializer$java_util_Collection;

    List __getparsers() {
        if (!this.__Fparsers) {
            return this.parsers;
        }
        return (List)this.__IM.onGet((Object)this, "parsers");
    }

    void __setparsers(List list) {
        if (!this.__Fparsers) {
            this.parsers = list;
            return;
        }
        this.__IM.onSet((Object)this, "parsers", (Object)list);
    }

    List __getserializers() {
        if (!this.__Fserializers) {
            return this.serializers;
        }
        return (List)this.__IM.onGet((Object)this, "serializers");
    }

    void __setserializers(List list) {
        if (!this.__Fserializers) {
            this.serializers = list;
            return;
        }
        this.__IM.onSet((Object)this, "serializers", (Object)list);
    }

    public Engine() {
        this(null);
    }

    private Engine(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public BodyParser getBodyParserEngineForContentType(String contentType) {
        BodyParser bodyParser;
        if (!this.__MgetBodyParserEngineForContentType$java_lang_String) {
            return this.__M_getBodyParserEngineForContentType(contentType);
        }
        try {
            this.__IM.onEntry((Object)this, "getBodyParserEngineForContentType$java_lang_String", new Object[]{contentType});
            bodyParser = this.__M_getBodyParserEngineForContentType(contentType);
            this.__IM.onExit((Object)this, "getBodyParserEngineForContentType$java_lang_String", (Object)bodyParser);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBodyParserEngineForContentType$java_lang_String", throwable);
            throw throwable;
        }
        return bodyParser;
    }

    private BodyParser __M_getBodyParserEngineForContentType(String contentType) {
        for (BodyParser parser : this.__getparsers()) {
            if (!parser.getContentTypes().contains(contentType)) continue;
            return parser;
        }
        LoggerFactory.getLogger(this.getClass()).info("Cannot find a body parser for " + contentType);
        return null;
    }

    public ContentSerializer getContentSerializerForContentType(String contentType) {
        ContentSerializer contentSerializer;
        if (!this.__MgetContentSerializerForContentType$java_lang_String) {
            return this.__M_getContentSerializerForContentType(contentType);
        }
        try {
            this.__IM.onEntry((Object)this, "getContentSerializerForContentType$java_lang_String", new Object[]{contentType});
            contentSerializer = this.__M_getContentSerializerForContentType(contentType);
            this.__IM.onExit((Object)this, "getContentSerializerForContentType$java_lang_String", (Object)contentSerializer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentSerializerForContentType$java_lang_String", throwable);
            throw throwable;
        }
        return contentSerializer;
    }

    private ContentSerializer __M_getContentSerializerForContentType(String contentType) {
        for (ContentSerializer renderer : this.__getserializers()) {
            if (!renderer.getContentType().equals(contentType)) continue;
            return renderer;
        }
        LoggerFactory.getLogger(this.getClass()).info("Cannot find a content renderer handling " + contentType);
        return null;
    }

    public ContentSerializer getBestSerializer(Collection<MediaType> mediaTypes) {
        ContentSerializer contentSerializer;
        if (!this.__MgetBestSerializer$java_util_Collection) {
            return this.__M_getBestSerializer(mediaTypes);
        }
        try {
            this.__IM.onEntry((Object)this, "getBestSerializer$java_util_Collection", new Object[]{mediaTypes});
            contentSerializer = this.__M_getBestSerializer(mediaTypes);
            this.__IM.onExit((Object)this, "getBestSerializer$java_util_Collection", (Object)contentSerializer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBestSerializer$java_util_Collection", throwable);
            throw throwable;
        }
        return contentSerializer;
    }

    private ContentSerializer __M_getBestSerializer(Collection<MediaType> mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            mediaTypes = ImmutableList.of((Object)MediaType.HTML_UTF_8);
        }
        for (MediaType type : mediaTypes) {
            for (ContentSerializer ser : this.__getserializers()) {
                MediaType mt = MediaType.parse((String)ser.getContentType());
                if (!mt.is(type.withoutParameters())) continue;
                return ser;
            }
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("parsers")) {
                this.__Fparsers = true;
            }
            if (set.contains("serializers")) {
                this.__Fserializers = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getBodyParserEngineForContentType$java_lang_String")) {
                this.__MgetBodyParserEngineForContentType$java_lang_String = true;
            }
            if (set.contains("getContentSerializerForContentType$java_lang_String")) {
                this.__MgetContentSerializerForContentType$java_lang_String = true;
            }
            if (set.contains("getBestSerializer$java_util_Collection")) {
                this.__MgetBestSerializer$java_util_Collection = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

