/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.ContentSerializer;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.Renderable;

@Component
@Instantiate
@Provides
public class JSONSerializer
implements ContentSerializer,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONSerializer.class);
    private boolean __Fjson;
    @Requires
    private Json json;
    boolean __MgetContentType;
    boolean __Mserialize$org_wisdom_api_http_Renderable;

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    public JSONSerializer() {
        this(null);
    }

    private JSONSerializer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String getContentType() {
        String string;
        if (!this.__MgetContentType) {
            return this.__M_getContentType();
        }
        try {
            this.__IM.onEntry((Object)this, "getContentType", new Object[0]);
            string = this.__M_getContentType();
            this.__IM.onExit((Object)this, "getContentType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getContentType() {
        return "application/json";
    }

    public void serialize(Renderable<?> renderable) {
        if (!this.__Mserialize$org_wisdom_api_http_Renderable) {
            this.__M_serialize(renderable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "serialize$org_wisdom_api_http_Renderable", new Object[]{renderable});
            this.__M_serialize(renderable);
            this.__IM.onExit((Object)this, "serialize$org_wisdom_api_http_Renderable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serialize$org_wisdom_api_http_Renderable", throwable);
            throw throwable;
        }
    }

    private void __M_serialize(Renderable<?> renderable) {
        JsonNode node = this.__getjson().toJson(renderable.content());
        if (node == null) {
            LOGGER.error("Cannot serialize result - cannot create a JSON Node from the response content");
            renderable.setSerializedForm("");
        } else {
            renderable.setSerializedForm(node.toString());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("json")) {
            this.__Fjson = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getContentType")) {
                this.__MgetContentType = true;
            }
            if (set.contains("serialize$org_wisdom_api_http_Renderable")) {
                this.__Mserialize$org_wisdom_api_http_Renderable = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

