/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.cache.ehcache;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.joda.time.Duration;
import org.wisdom.api.configuration.ApplicationConfiguration;

@Component(immediate=true)
@Provides
@Instantiate
public class EhCacheService
implements org.wisdom.api.cache.Cache,
Pojo {
    InstanceManager __IM;
    private static final String WISDOM_KEY = "wisdom";
    public static final String CUSTOM_CONFIGURATION = "conf/ehcache.xml";
    public static final String INTERNAL_CONFIGURATION = "org/wisdom/cache/ehcache/ehcache-default.xml";
    private boolean __Fcache;
    private Cache cache;
    private boolean __Fmanager;
    private CacheManager manager;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    boolean __Mstart;
    boolean __Mstop;
    boolean __Mset$java_lang_String$java_lang_Object$int;
    boolean __Mset$java_lang_String$java_lang_Object$org_joda_time_Duration;
    boolean __Mget$java_lang_String;
    boolean __Mremove$java_lang_String;

    Cache __getcache() {
        if (!this.__Fcache) {
            return this.cache;
        }
        return (Cache)this.__IM.onGet((Object)this, "cache");
    }

    void __setcache(Cache cache) {
        if (!this.__Fcache) {
            this.cache = cache;
            return;
        }
        this.__IM.onSet((Object)this, "cache", (Object)cache);
    }

    CacheManager __getmanager() {
        if (!this.__Fmanager) {
            return this.manager;
        }
        return (CacheManager)this.__IM.onGet((Object)this, "manager");
    }

    void __setmanager(CacheManager cacheManager) {
        if (!this.__Fmanager) {
            this.manager = cacheManager;
            return;
        }
        this.__IM.onSet((Object)this, "manager", (Object)cacheManager);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    public EhCacheService() {
        this(null);
    }

    private EhCacheService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_start() {
        File config = new File(this.__getconfiguration().getBaseDir(), CUSTOM_CONFIGURATION);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (config.isFile()) {
                this.__setmanager(CacheManager.create((String)config.getAbsolutePath()));
            } else {
                URL url = EhCacheService.class.getClassLoader().getResource(INTERNAL_CONFIGURATION);
                if (url != null) {
                    this.__setmanager(CacheManager.create((URL)url));
                } else {
                    throw new ExceptionInInitializerError("Cannot instantiate EhCache, cannot load org/wisdom/cache/ehcache/ehcache-default.xml file");
                }
            }
            this.__getmanager().addCache(WISDOM_KEY);
            this.__setcache(this.__getmanager().getCache(WISDOM_KEY));
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getmanager().removeCache(WISDOM_KEY);
    }

    public void set(String key, Object value, int expiration) {
        if (!this.__Mset$java_lang_String$java_lang_Object$int) {
            this.__M_set(key, value, expiration);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "set$java_lang_String$java_lang_Object$int", new Object[]{key, value, new Integer(expiration)});
            this.__M_set(key, value, expiration);
            this.__IM.onExit((Object)this, "set$java_lang_String$java_lang_Object$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "set$java_lang_String$java_lang_Object$int", throwable);
            throw throwable;
        }
    }

    private void __M_set(String key, Object value, int expiration) {
        Element element = new Element((Object)key, value);
        if (expiration == 0) {
            element.setEternal(true);
        }
        element.setTimeToLive(expiration);
        this.__getcache().put(element);
    }

    public void set(String key, Object value, Duration expiration) {
        if (!this.__Mset$java_lang_String$java_lang_Object$org_joda_time_Duration) {
            this.__M_set(key, value, expiration);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "set$java_lang_String$java_lang_Object$org_joda_time_Duration", new Object[]{key, value, expiration});
            this.__M_set(key, value, expiration);
            this.__IM.onExit((Object)this, "set$java_lang_String$java_lang_Object$org_joda_time_Duration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "set$java_lang_String$java_lang_Object$org_joda_time_Duration", throwable);
            throw throwable;
        }
    }

    private void __M_set(String key, Object value, Duration expiration) {
        Element element = new Element((Object)key, value);
        if (expiration == null) {
            element.setEternal(true);
        } else {
            element.setTimeToLive((int)expiration.getStandardSeconds());
        }
        this.__getcache().put(element);
    }

    public Object get(String key) {
        Object object;
        if (!this.__Mget$java_lang_String) {
            return this.__M_get(key);
        }
        try {
            this.__IM.onEntry((Object)this, "get$java_lang_String", new Object[]{key});
            object = this.__M_get(key);
            this.__IM.onExit((Object)this, "get$java_lang_String", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "get$java_lang_String", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_get(String key) {
        Element element = this.__getcache().get((Serializable)((Object)key));
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public boolean remove(String key) {
        boolean bl;
        if (!this.__Mremove$java_lang_String) {
            return this.__M_remove(key);
        }
        try {
            this.__IM.onEntry((Object)this, "remove$java_lang_String", new Object[]{key});
            bl = this.__M_remove(key);
            this.__IM.onExit((Object)this, "remove$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "remove$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_remove(String key) {
        return this.__getcache().remove((Serializable)((Object)key));
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("cache")) {
                this.__Fcache = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("manager")) {
                this.__Fmanager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("set$java_lang_String$java_lang_Object$int")) {
                this.__Mset$java_lang_String$java_lang_Object$int = true;
            }
            if (set.contains("set$java_lang_String$java_lang_Object$org_joda_time_Duration")) {
                this.__Mset$java_lang_String$java_lang_Object$org_joda_time_Duration = true;
            }
            if (set.contains("get$java_lang_String")) {
                this.__Mget$java_lang_String = true;
            }
            if (set.contains("remove$java_lang_String")) {
                this.__Mremove$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

