/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.wisdom.api.Controller;
import org.wisdom.api.annotations.Body;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.router.parameters.ActionParameter;
import org.wisdom.api.router.parameters.Source;
import org.wisdom.router.DefaultWebSocketCallback;
import org.wisdom.router.WebSocketRouter;

public class OnMessageWebSocketCallback
extends DefaultWebSocketCallback {
    public OnMessageWebSocketCallback(Controller controller, Method method, String uri, WebSocketRouter router) {
        super(controller, method, uri, router);
    }

    @Override
    public List<ActionParameter> buildArguments(Method method) {
        ArrayList<ActionParameter> arguments = new ArrayList<ActionParameter>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] typesOfParameters = method.getParameterTypes();
        Type[] genericTypeOfParameters = method.getGenericParameterTypes();
        for (int i = 0; i < annotations.length; ++i) {
            boolean sourceDetected = false;
            for (int j = 0; !sourceDetected && j < annotations[i].length; ++j) {
                Annotation annotation = annotations[i][j];
                if (annotation instanceof Parameter) {
                    Parameter parameter = (Parameter)annotation;
                    arguments.add(new ActionParameter(parameter.value(), Source.PARAMETER, typesOfParameters[i], genericTypeOfParameters[i]));
                    sourceDetected = true;
                }
                if (!(annotation instanceof Body)) continue;
                arguments.add(new ActionParameter(null, Source.BODY, typesOfParameters[i], genericTypeOfParameters[i]));
                sourceDetected = true;
            }
            if (sourceDetected) continue;
            WebSocketRouter.getLogger().error("The method {} has a parameter without annotations indicating  the injected data. Only @Parameter and @Body annotations are supported in web sockets callbacks receiving events", (Object)method.getName());
            return null;
        }
        return arguments;
    }
}

