/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router;

import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.Validator;
import org.wisdom.api.Controller;
import org.wisdom.api.annotations.Interception;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.interception.Filter;
import org.wisdom.api.interception.Interceptor;
import org.wisdom.api.interception.RequestContext;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.parameters.ActionParameter;
import org.wisdom.router.RequestRouter;
import org.wisdom.router.parameter.Bindings;

public class RouteDelegate
extends Route {
    private final Route route;
    private final RequestRouter router;
    private final boolean mustValidate;
    private final Map<String, Object> interceptors;

    public RouteDelegate(RequestRouter router, Route route) {
        this.route = route;
        this.router = router;
        if (!route.isUnbound()) {
            this.mustValidate = RouteDelegate.detectValidationRequirement(route.getControllerMethod());
            this.interceptors = this.extractInterceptors();
        } else {
            this.mustValidate = false;
            this.interceptors = Collections.emptyMap();
        }
    }

    private Map<String, Object> extractInterceptors() {
        Annotation[] methodAnnotations;
        Annotation[] classAnnotations;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Annotation annotation : classAnnotations = this.route.getControllerClass().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Interception.class)) continue;
            map.put(annotation.annotationType().getName(), annotation);
        }
        for (Annotation annotation : methodAnnotations = this.route.getControllerMethod().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Interception.class)) continue;
            map.put(annotation.annotationType().getName(), annotation);
        }
        return map;
    }

    private static boolean detectValidationRequirement(Method method) {
        Annotation[][] annotations;
        Annotation[][] annotationArray = annotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] array;
            for (Annotation annotation : array = annotationArray[i]) {
                if (!RouteDelegate.isConstraint(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConstraint(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Constraint.class) || annotation.annotationType().equals(Valid.class);
    }

    public String getUrl() {
        return this.route.getUrl();
    }

    public HttpMethod getHttpMethod() {
        return this.route.getHttpMethod();
    }

    public Class<? extends Controller> getControllerClass() {
        return this.route.getControllerClass();
    }

    public Method getControllerMethod() {
        return this.route.getControllerMethod();
    }

    public boolean matches(HttpMethod method, String uri) {
        return this.route.matches(method, uri);
    }

    public boolean matches(String method, String uri) {
        return this.route.matches(method, uri);
    }

    public Map<String, String> getPathParametersEncoded(String uri) {
        return this.route.getPathParametersEncoded(uri);
    }

    public int isCompliantWithRequestContentType(Request request) {
        return this.route.isCompliantWithRequestContentType(request);
    }

    public Route accepting(String ... types) {
        return this.route.accepting(types);
    }

    public Route accepts(String ... types) {
        return this.route.accepts(types);
    }

    public Set<MediaType> getAcceptedMediaTypes() {
        return this.route.getAcceptedMediaTypes();
    }

    public Set<MediaType> getProducedMediaTypes() {
        return this.route.getProducedMediaTypes();
    }

    public int getUnboundStatus() {
        return this.route.getUnboundStatus();
    }

    public Route produces(String ... types) {
        return this.route.produces(types);
    }

    public Route producing(String ... provide) {
        return this.route.producing(provide);
    }

    public boolean isCompliantWithRequestAccept(Request request) {
        return this.route.isCompliantWithRequestAccept(request);
    }

    public Controller getControllerObject() {
        return this.route.getControllerObject();
    }

    public List<ActionParameter> getArguments() {
        return this.route.getArguments();
    }

    public Result invoke() throws Exception {
        Context context = (Context)Context.CONTEXT.get();
        Preconditions.checkNotNull((Object)context);
        Set<Filter> filters = this.router.getFilters();
        ArrayList<Object> chain = new ArrayList<Object>();
        for (Filter filter : filters) {
            if (filter instanceof Interceptor || !filter.uri().matcher(this.route.getUrl()).matches()) continue;
            chain.add(filter);
        }
        LinkedHashMap itcpConfiguration = new LinkedHashMap();
        if (!this.interceptors.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.interceptors.entrySet()) {
                Interceptor<?> interceptor = this.getInterceptorForAnnotation(entry.getKey());
                if (interceptor == null) {
                    return Results.badRequest((String)("Missing interceptor handling " + entry.getKey()));
                }
                itcpConfiguration.put(interceptor, entry.getValue());
                chain.add(interceptor);
            }
        }
        EndOfChainInvoker endOfChainInvoker = new EndOfChainInvoker();
        RequestContext requestContext = new RequestContext((Route)this, chain, itcpConfiguration, null, (Filter)endOfChainInvoker);
        return requestContext.proceed();
    }

    private Interceptor<?> getInterceptorForAnnotation(String className) {
        List<Interceptor<?>> localInterceptors = this.router.getInterceptors();
        if (localInterceptors == null) {
            return null;
        }
        for (Interceptor<?> interceptor : localInterceptors) {
            if (!interceptor.annotation().getName().equals(className)) continue;
            return interceptor;
        }
        return null;
    }

    public String toString() {
        return this.route.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Route) {
            return this.route.equals(o);
        }
        return o.equals((Object)this);
    }

    public int hashCode() {
        return this.route.hashCode();
    }

    public boolean isUnbound() {
        return this.route.isUnbound();
    }

    private class EndOfChainInvoker
    implements Filter {
        private EndOfChainInvoker() {
        }

        public Result call(Route route, RequestContext context) throws InvocationTargetException, IllegalAccessException {
            Set mediaTypes;
            Set violations;
            Validator validator;
            if (RouteDelegate.this.isUnbound()) {
                return new Result().status(route.getUnboundStatus()).noContentIfNone();
            }
            List<ActionParameter> arguments = RouteDelegate.this.getArguments();
            Object[] parameters = new Object[arguments.size()];
            for (int i = 0; i < arguments.size(); ++i) {
                ActionParameter argument = arguments.get(i);
                parameters[i] = Bindings.create(argument, context.context(), RouteDelegate.this.router.getParameterConverterEngine());
            }
            if (RouteDelegate.this.mustValidate && (validator = RouteDelegate.this.router.getValidator()) != null && !(violations = validator.forExecutables().validateParameters((Object)RouteDelegate.this.getControllerObject(), RouteDelegate.this.getControllerMethod(), parameters, new Class[0])).isEmpty()) {
                return Results.badRequest((Object)violations).json();
            }
            context.setParameters(parameters);
            Result result = (Result)RouteDelegate.this.getControllerMethod().invoke((Object)RouteDelegate.this.getControllerObject(), parameters);
            if (!result.getHeaders().containsKey("Vary")) {
                String headers = null;
                if (!RouteDelegate.this.getAcceptedMediaTypes().isEmpty()) {
                    headers = "Content-Type";
                }
                if (!RouteDelegate.this.getProducedMediaTypes().isEmpty()) {
                    headers = headers == null ? "Accept" : headers + ", Accept";
                }
                if (headers != null) {
                    result.with("Vary", headers);
                }
            }
            if ((mediaTypes = route.getProducedMediaTypes()).isEmpty() || result.getContentType() != null || result.getRenderable() != null && result.getRenderable().mimetype() != null) {
                return result;
            }
            if (mediaTypes.size() == 1) {
                result.as(((MediaType)mediaTypes.iterator().next()).toString());
            }
            return result;
        }

        public Pattern uri() {
            return null;
        }

        public int priority() {
            return -1;
        }
    }
}

