/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router.parameter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.http.Context;
import org.wisdom.api.router.parameters.ActionParameter;
import org.wisdom.router.parameter.Bindings;
import org.wisdom.router.parameter.RouteParameterHandler;

public class BeanHandler
implements RouteParameterHandler {
    private static final String SETTER_PREFIX = "set";
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanHandler.class);

    @Override
    public Object create(ActionParameter argument, Context context, ParameterFactories engine) {
        Object object = this.createNewInstance(argument.getRawType(), context, engine);
        for (Method method : argument.getRawType().getMethods()) {
            Type genericTypeOfParameter;
            Class<?> typesOfParameter;
            if (!method.getName().startsWith(SETTER_PREFIX)) continue;
            if (method.getParameterTypes().length != 1) {
                LOGGER.warn("The class {} has a setter method called {} but with too many parameters to be injected with the 'BeanParameter' annotation", (Object)argument.getRawType().getName(), (Object)method.getName());
                continue;
            }
            Annotation[] annotation = method.getParameterAnnotations()[0];
            ActionParameter parameter = ActionParameter.from((Member)method, (Annotation[])annotation, typesOfParameter = method.getParameterTypes()[0], (Type)(genericTypeOfParameter = method.getGenericParameterTypes()[0]));
            Object value = Bindings.create(parameter, context, engine);
            if (value == null) continue;
            this.inject(object, method, value);
        }
        return object;
    }

    private void inject(Object object, Method method, Object value) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            method.invoke(object, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot inject the value " + value + " in the method " + method.getName() + " from " + object.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot inject the value " + value + " in the method " + method.getName() + " from " + object.getClass().getName(), e.getTargetException());
        }
    }

    public static List<ActionParameter> buildActionParameterList(Constructor cst) {
        ArrayList<ActionParameter> arguments = new ArrayList<ActionParameter>();
        Annotation[][] annotations = cst.getParameterAnnotations();
        Class<?>[] typesOfParameters = cst.getParameterTypes();
        Type[] genericTypeOfParameters = cst.getGenericParameterTypes();
        for (int i = 0; i < annotations.length; ++i) {
            arguments.add(ActionParameter.from((Member)cst, (Annotation[])annotations[i], typesOfParameters[i], (Type)genericTypeOfParameters[i]));
        }
        return arguments;
    }

    private Object createNewInstance(Class<?> rawType, Context context, ParameterFactories engine) {
        try {
            Constructor<?> cst = BeanHandler.getNoArgConstructor(rawType);
            if (cst != null) {
                return cst.newInstance(new Object[0]);
            }
            cst = this.findConstructor(rawType);
            if (cst == null) {
                throw new IllegalArgumentException("Cannot build an instance of '" + rawType.getName() + "', " + "cannot find a suitable constructor.");
            }
            List<ActionParameter> parameters = BeanHandler.buildActionParameterList(cst);
            Object[] values = new Object[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                ActionParameter argument = parameters.get(i);
                values[i] = Bindings.create(argument, context, engine);
            }
            return cst.newInstance(values);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot build an instance of '" + rawType.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot build an instance of '" + rawType.getName(), e.getTargetException());
        }
    }

    private Constructor<?> findConstructor(Class<?> rawType) {
        for (Constructor<?> constructor : rawType.getConstructors()) {
            Annotation[][] annotations;
            for (Annotation[] param : annotations = constructor.getParameterAnnotations()) {
                if (param.length == 0) continue;
                return constructor;
            }
        }
        return null;
    }

    private static Constructor<?> getNoArgConstructor(Class<?> rawType) {
        try {
            return rawType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

