/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router.parameter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.http.Context;
import org.wisdom.api.router.parameters.ActionParameter;
import org.wisdom.api.router.parameters.Source;
import org.wisdom.router.parameter.AttributeHandler;
import org.wisdom.router.parameter.BeanHandler;
import org.wisdom.router.parameter.BodyHandler;
import org.wisdom.router.parameter.HttpHandler;
import org.wisdom.router.parameter.ParameterHandler;
import org.wisdom.router.parameter.RouteParameterHandler;

public class Bindings {
    private static final Map<Source, RouteParameterHandler> BINDINGS = new HashMap<Source, RouteParameterHandler>();

    public static void bind(Source source, RouteParameterHandler handler) {
        if (BINDINGS.containsKey(source)) {
            LoggerFactory.getLogger(Bindings.class).warn("Replacing a route parameter binding for {} by {}", (Object)source.name(), (Object)handler);
        }
        BINDINGS.put(source, handler);
    }

    public static Object create(ActionParameter argument, Context context, ParameterFactories engine) {
        RouteParameterHandler handler = BINDINGS.get(argument.getSource());
        if (handler != null) {
            return handler.create(argument, context, engine);
        }
        LoggerFactory.getLogger(Bindings.class).warn("Unsupported route parameter in method : {}", (Object)argument.getSource().name());
        return null;
    }

    public static boolean supportMultipleValues(Class<?> rawType) {
        return rawType.isArray() || Collection.class.isAssignableFrom(rawType);
    }

    static {
        Bindings.bind(Source.BODY, new BodyHandler());
        Bindings.bind(Source.PARAMETER, new ParameterHandler());
        Bindings.bind(Source.QUERY, new ParameterHandler());
        Bindings.bind(Source.PATH, new ParameterHandler());
        Bindings.bind(Source.FORM, new AttributeHandler());
        Bindings.bind(Source.HTTP, new HttpHandler());
        Bindings.bind(Source.BEAN, new BeanHandler());
    }
}

