/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router.parameter;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.FlashCookie;
import org.wisdom.api.cookies.SessionCookie;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Request;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.parameters.ActionParameter;
import org.wisdom.router.parameter.RouteParameterHandler;

public class HttpHandler
implements RouteParameterHandler {
    @Override
    public Object create(ActionParameter argument, Context context, ParameterFactories engine) {
        if (argument.getRawType().equals(Context.class)) {
            return context;
        }
        Set handled = engine.getTypesHandledByFactories();
        if (handled.contains(argument.getRawType())) {
            return engine.newInstance(context, argument.getRawType());
        }
        if (argument.getRawType().equals(Request.class)) {
            return context.request();
        }
        if (argument.getRawType().equals(SessionCookie.class)) {
            return context.session();
        }
        if (argument.getRawType().equals(FlashCookie.class)) {
            return context.flash();
        }
        if (argument.getRawType().equals(Cookie.class)) {
            if (!Strings.isNullOrEmpty((String)argument.getName())) {
                return context.cookie(argument.getName());
            }
            throw new IllegalArgumentException("Missing cookie's name set in the @HttpParameter annotation");
        }
        if (argument.getRawType().equals(Route.class)) {
            return context.route();
        }
        if (argument.getRawType().equals(BufferedReader.class) || argument.getRawType().equals(Reader.class)) {
            try {
                return context.reader();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot inject the reader object in the @HttpParameter injected parameter", e);
            }
        }
        if (Strings.isNullOrEmpty((String)argument.getName())) {
            throw new IllegalArgumentException("Cannot inject the value of a HTTP header and request scope value in the @HttpParameter - header's name not defined");
        }
        Object requestScopeValue = context.request().data().get(argument.getName());
        if (requestScopeValue != null) {
            return requestScopeValue;
        }
        if (context.header(argument.getName()) != null || argument.getDefaultValue() != null) {
            return engine.convertValues((Collection)context.headers(argument.getName()), argument.getRawType(), argument.getGenericType(), argument.getDefaultValue());
        }
        if (List.class.isAssignableFrom(argument.getRawType())) {
            return Collections.emptyList();
        }
        if (Set.class.isAssignableFrom(argument.getRawType())) {
            return Collections.emptySet();
        }
        if (Collections.class.isAssignableFrom(argument.getRawType())) {
            return Collections.emptyList();
        }
        return null;
    }
}

