/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router.security;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.interception.Interceptor;
import org.wisdom.api.interception.RequestContext;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.security.Authenticator;

@Component(immediate=true)
@Provides(specifications={Interceptor.class})
@Instantiate
public class AuthenticationInterceptor
extends Interceptor<Authenticated> {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    private boolean __Fauthenticators;
    @Requires(optional=true)
    Authenticator[] authenticators;
    boolean __Mcall$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext;
    boolean __MgetAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String;
    boolean __Mannotation;
    boolean __Mcall$java_lang_Object$org_wisdom_api_interception_RequestContext;

    Authenticator[] __getauthenticators() {
        if (!this.__Fauthenticators) {
            return this.authenticators;
        }
        return (Authenticator[])this.__IM.onGet((Object)this, "authenticators");
    }

    void __setauthenticators(Authenticator[] authenticatorArray) {
        if (!this.__Fauthenticators) {
            this.authenticators = authenticatorArray;
            return;
        }
        this.__IM.onSet((Object)this, "authenticators", (Object)authenticatorArray);
    }

    public AuthenticationInterceptor() {
        this(null);
    }

    private AuthenticationInterceptor(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Result call(Authenticated configuration, RequestContext context) throws Exception {
        Result result;
        if (!this.__Mcall$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext) {
            return this.__M_call(configuration, context);
        }
        try {
            this.__IM.onEntry((Object)this, "call$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext", new Object[]{configuration, context});
            result = this.__M_call(configuration, context);
            this.__IM.onExit((Object)this, "call$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "call$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_call(Authenticated configuration, RequestContext context) throws Exception {
        Authenticator authenticator = this.getAuthenticator(context, configuration.value());
        if (authenticator != null) {
            String username = authenticator.getUserName(context.context());
            if (username == null) {
                context.context().request().setUsername(null);
                return authenticator.onUnauthorized(context.context());
            }
            context.context().request().setUsername(username);
            return context.proceed();
        }
        context.context().request().setUsername(null);
        return Results.unauthorized();
    }

    private Authenticator getAuthenticator(RequestContext context, String value) {
        Authenticator authenticator;
        if (!this.__MgetAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String) {
            return this.__M_getAuthenticator(context, value);
        }
        try {
            this.__IM.onEntry((Object)this, "getAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String", new Object[]{context, value});
            authenticator = this.__M_getAuthenticator(context, value);
            this.__IM.onExit((Object)this, "getAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String", (Object)authenticator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String", throwable);
            throw throwable;
        }
        return authenticator;
    }

    private Authenticator __M_getAuthenticator(RequestContext context, String value) {
        if (this.__getauthenticators().length == 0) {
            return null;
        }
        if (value == null || value.length() == 0) {
            if (this.__getauthenticators().length > 1) {
                LOGGER.warn("The action {} require authentication, but does not specify the authenticator. But, several authenticators are available, picked one randomly ({})", (Object)context.context().path(), (Object)this.__getauthenticators()[0]);
            }
            return this.__getauthenticators()[0];
        }
        for (Authenticator authenticator : this.__getauthenticators()) {
            if (!authenticator.getName().equals(value)) continue;
            return authenticator;
        }
        return null;
    }

    public Class<Authenticated> annotation() {
        Class<Authenticated> clazz;
        if (!this.__Mannotation) {
            return this.__M_annotation();
        }
        try {
            this.__IM.onEntry((Object)this, "annotation", new Object[0]);
            clazz = this.__M_annotation();
            this.__IM.onExit((Object)this, "annotation", clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "annotation", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class<Authenticated> __M_annotation() {
        return Authenticated.class;
    }

    private Result __M_call(Object object, RequestContext requestContext) throws Exception {
        return this.call((Authenticated)object, requestContext);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("authenticators")) {
            this.__Fauthenticators = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("call$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$org_wisdom_api_security_Authenticated$org_wisdom_api_interception_RequestContext = true;
            }
            if (set.contains("getAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String")) {
                this.__MgetAuthenticator$org_wisdom_api_interception_RequestContext$java_lang_String = true;
            }
            if (set.contains("annotation")) {
                this.__Mannotation = true;
            }
            if (set.contains("call$java_lang_Object$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$java_lang_Object$org_wisdom_api_interception_RequestContext = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

