/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.handler.RestNodeTypeHandler;
import org.modeshape.web.jcr.rest.model.RestNodeType;
import org.wisdom.api.annotations.Service;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Result;
import org.wisdom.jcr.modeshape.api.RepositoryManager;

@Service(value={RestNodeTypeHandler.class})
public final class RestNodeTypeHandlerImpl
extends AbstractHandler
implements RestNodeTypeHandler,
Pojo {
    InstanceManager __IM;
    private static final int HTTP_NOT_IMPLEMENTED = 501;
    private boolean __FrepositoryManager;
    @Requires
    RepositoryManager repositoryManager;
    boolean __MgetNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String;
    boolean __MimportCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream;
    boolean __McreateOkResponse$java_util_List;
    boolean __MregisterCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager;
    boolean __MgetRepositoryManager;

    RepositoryManager __getrepositoryManager() {
        if (!this.__FrepositoryManager) {
            return this.repositoryManager;
        }
        return (RepositoryManager)this.__IM.onGet((Object)this, "repositoryManager");
    }

    void __setrepositoryManager(RepositoryManager repositoryManager) {
        if (!this.__FrepositoryManager) {
            this.repositoryManager = repositoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryManager", (Object)repositoryManager);
    }

    public RestNodeTypeHandlerImpl() {
        this(null);
    }

    private RestNodeTypeHandlerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public RestNodeType getNodeType(Request request, String repositoryName, String workspaceName, String nodeTypeName) throws RepositoryException {
        RestNodeType restNodeType;
        if (!this.__MgetNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_getNodeType(request, repositoryName, workspaceName, nodeTypeName);
        }
        try {
            this.__IM.onEntry((Object)this, "getNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName, nodeTypeName});
            restNodeType = this.__M_getNodeType(request, repositoryName, workspaceName, nodeTypeName);
            this.__IM.onExit((Object)this, "getNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", (Object)restNodeType);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return restNodeType;
    }

    private RestNodeType __M_getNodeType(Request request, String repositoryName, String workspaceName, String nodeTypeName) throws RepositoryException {
        Session session = this.getSession(request, repositoryName, workspaceName);
        javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodeTypeManager.getNodeType(nodeTypeName);
        return new RestNodeType(nodeType, RestHelper.repositoryUrl(request));
    }

    @Override
    public Result importCND(Request request, String repositoryName, String workspaceName, boolean allowUpdate, InputStream cndInputStream) throws RepositoryException {
        Result result;
        if (!this.__MimportCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream) {
            return this.__M_importCND(request, repositoryName, workspaceName, allowUpdate, cndInputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "importCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream", new Object[]{request, repositoryName, workspaceName, new Boolean(allowUpdate), cndInputStream});
            result = this.__M_importCND(request, repositoryName, workspaceName, allowUpdate, cndInputStream);
            this.__IM.onExit((Object)this, "importCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "importCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_importCND(Request request, String repositoryName, String workspaceName, boolean allowUpdate, InputStream cndInputStream) throws RepositoryException {
        CheckArg.isNotNull((Object)cndInputStream, (String)"request body");
        Session session = this.getSession(request, repositoryName, workspaceName);
        javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        if (!(nodeTypeManager instanceof NodeTypeManager)) {
            return new Result(501);
        }
        NodeTypeManager modeshapeTypeManager = (NodeTypeManager)nodeTypeManager;
        try {
            List<RestNodeType> registeredTypes = this.registerCND(request, allowUpdate, cndInputStream, modeshapeTypeManager);
            return this.createOkResponse(registeredTypes);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Result createOkResponse(List<RestNodeType> registeredTypes) {
        Result result;
        if (!this.__McreateOkResponse$java_util_List) {
            return this.__M_createOkResponse(registeredTypes);
        }
        try {
            this.__IM.onEntry((Object)this, "createOkResponse$java_util_List", new Object[]{registeredTypes});
            result = this.__M_createOkResponse(registeredTypes);
            this.__IM.onExit((Object)this, "createOkResponse$java_util_List", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOkResponse$java_util_List", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_createOkResponse(List<RestNodeType> registeredTypes) {
        Result result = new Result();
        result.status(200);
        result.render(registeredTypes);
        return result;
    }

    private List<RestNodeType> registerCND(Request request, boolean allowUpdate, InputStream cndInputStream, NodeTypeManager modeshapeTypeManager) throws IOException, RepositoryException {
        List<RestNodeType> list;
        if (!this.__MregisterCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager) {
            return this.__M_registerCND(request, allowUpdate, cndInputStream, modeshapeTypeManager);
        }
        try {
            this.__IM.onEntry((Object)this, "registerCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager", new Object[]{request, new Boolean(allowUpdate), cndInputStream, modeshapeTypeManager});
            list = this.__M_registerCND(request, allowUpdate, cndInputStream, modeshapeTypeManager);
            this.__IM.onExit((Object)this, "registerCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager", throwable);
            throw throwable;
        }
        return list;
    }

    private List<RestNodeType> __M_registerCND(Request request, boolean allowUpdate, InputStream cndInputStream, NodeTypeManager modeshapeTypeManager) throws IOException, RepositoryException {
        NodeTypeIterator nodeTypeIterator = modeshapeTypeManager.registerNodeTypes(cndInputStream, allowUpdate);
        ArrayList<RestNodeType> result = new ArrayList<RestNodeType>();
        String baseUrl = RestHelper.repositoryUrl(request);
        while (nodeTypeIterator.hasNext()) {
            result.add(new RestNodeType(nodeTypeIterator.nextNodeType(), baseUrl));
        }
        return result;
    }

    @Override
    protected RepositoryManager getRepositoryManager() {
        RepositoryManager repositoryManager;
        if (!this.__MgetRepositoryManager) {
            return this.__M_getRepositoryManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryManager", new Object[0]);
            repositoryManager = this.__M_getRepositoryManager();
            this.__IM.onExit((Object)this, "getRepositoryManager", (Object)repositoryManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryManager", throwable);
            throw throwable;
        }
        return repositoryManager;
    }

    private RepositoryManager __M_getRepositoryManager() {
        return this.__getrepositoryManager();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("repositoryManager")) {
            this.__FrepositoryManager = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetNodeType$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("importCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream")) {
                this.__MimportCND$org_wisdom_api_http_Request$java_lang_String$java_lang_String$boolean$java_io_InputStream = true;
            }
            if (set.contains("createOkResponse$java_util_List")) {
                this.__McreateOkResponse$java_util_List = true;
            }
            if (set.contains("registerCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager")) {
                this.__MregisterCND$org_wisdom_api_http_Request$boolean$java_io_InputStream$org_modeshape_jcr_api_nodetype_NodeTypeManager = true;
            }
            if (set.contains("getRepositoryManager")) {
                this.__MgetRepositoryManager = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

