/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.wisdom.api.content.Json;

public final class RestQueryResult
implements JSONAble {
    private final Map<String, String> columns = new LinkedHashMap<String, String>();
    private final List<RestRow> rows = new ArrayList<RestRow>();

    public RestQueryResult addColumn(String name, String type) {
        if (!StringUtil.isBlank((String)name)) {
            this.columns.put(name, type);
        }
        return this;
    }

    public RestQueryResult addRow(RestRow row) {
        this.rows.add(row);
        return this;
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode result = json.newObject();
        if (!this.columns.isEmpty()) {
            ObjectNode columnsNode = result.putObject("columns");
            for (String column : this.columns.keySet()) {
                columnsNode.put(column, this.columns.get(column));
            }
        }
        if (!this.rows.isEmpty()) {
            ArrayNode rows = result.putArray("rows");
            for (RestRow row : this.rows) {
                rows.add((JsonNode)row.toJSON(json));
            }
        }
        return result;
    }

    public class RestRow
    implements JSONAble {
        private final Map<String, String> values = new LinkedHashMap<String, String>();

        public void addValue(String name, String value) {
            if (!StringUtil.isBlank((String)name) && !StringUtil.isBlank((String)value)) {
                this.values.put(name, value);
            }
        }

        @Override
        public ObjectNode toJSON(Json json) {
            ObjectNode objectNode = json.newObject();
            for (String key : this.values.keySet()) {
                objectNode.put(key, this.values.get(key));
            }
            return objectNode;
        }
    }
}

