/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.wisdom.api.content.Json;

public final class RestWorkspaces
implements JSONAble {
    private final List<Workspace> workspaces = new ArrayList<Workspace>();

    public Workspace addWorkspace(String name, String repositoryUrl) {
        Workspace workspace = new Workspace(name, repositoryUrl);
        this.workspaces.add(workspace);
        return workspace;
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode result = json.newObject();
        ArrayNode workspaces = result.putArray("workspaces");
        for (Workspace workspace : this.workspaces) {
            workspaces.add((JsonNode)workspace.toJSON(json));
        }
        return result;
    }

    private class Workspace
    implements JSONAble {
        private final String name;
        private final String repositoryUrl;
        private final String queryUrl;
        private final String itemsUrl;
        private final String binaryUrl;
        private final String nodeTypesUrl;

        public Workspace(String name, String repositoryUrl) {
            this.name = name;
            this.repositoryUrl = repositoryUrl;
            this.queryUrl = RestHelper.urlFrom(repositoryUrl, name, "query");
            this.itemsUrl = RestHelper.urlFrom(repositoryUrl, name, "items");
            this.binaryUrl = RestHelper.urlFrom(repositoryUrl, name, "binary");
            this.nodeTypesUrl = RestHelper.urlFrom(repositoryUrl, name, "nodetypes");
        }

        @Override
        public ObjectNode toJSON(Json json) {
            ObjectNode result = json.newObject();
            result.put("name", this.name);
            result.put("repository", this.repositoryUrl);
            result.put("items", this.itemsUrl);
            result.put("query", this.queryUrl);
            result.put("binary", this.binaryUrl);
            result.put("nodeTypes", this.nodeTypesUrl);
            return result;
        }
    }
}

