/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.handler.ItemHandlerImpl;
import org.modeshape.web.jcr.rest.handler.RestItemHandler;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.wisdom.api.annotations.Service;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.Request;
import org.wisdom.jcr.modeshape.api.RepositoryManager;

@Service(value={RestItemHandler.class})
public final class RestItemHandlerImpl
extends ItemHandlerImpl
implements RestItemHandler,
Pojo {
    InstanceManager __IM;
    private boolean __Fjson;
    @Requires
    Json json;
    private boolean __FrepositoryManager;
    @Requires
    RepositoryManager repositoryManager;
    boolean __Mitem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int;
    boolean __MaddItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MgetJson;
    boolean __MgetProperties$com_fasterxml_jackson_databind_JsonNode;
    boolean __MnewNodeName$java_lang_String;
    boolean __MupdateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MstringToJSONObject$java_lang_String;
    boolean __MstringToJSONArray$java_lang_String;
    boolean __MaddItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String;
    boolean __MupdateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdeleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String;
    boolean __MupdateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap;
    boolean __McreateNodesByPathMap$com_fasterxml_jackson_databind_JsonNode;
    boolean __MaddMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session;
    boolean __MgetRepositoryManager;

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    RepositoryManager __getrepositoryManager() {
        if (!this.__FrepositoryManager) {
            return this.repositoryManager;
        }
        return (RepositoryManager)this.__IM.onGet((Object)this, "repositoryManager");
    }

    void __setrepositoryManager(RepositoryManager repositoryManager) {
        if (!this.__FrepositoryManager) {
            this.repositoryManager = repositoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryManager", (Object)repositoryManager);
    }

    public RestItemHandlerImpl() {
        this(null);
    }

    private RestItemHandlerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public RestItem item(Request request, String repositoryName, String workspaceName, String path, int depth) throws RepositoryException {
        RestItem restItem;
        if (!this.__Mitem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int) {
            return this.__M_item(request, repositoryName, workspaceName, path, depth);
        }
        try {
            this.__IM.onEntry((Object)this, "item$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int", new Object[]{request, repositoryName, workspaceName, path, new Integer(depth)});
            restItem = this.__M_item(request, repositoryName, workspaceName, path, depth);
            this.__IM.onExit((Object)this, "item$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int", (Object)restItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "item$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int", throwable);
            throw throwable;
        }
        return restItem;
    }

    private RestItem __M_item(Request request, String repositoryName, String workspaceName, String path, int depth) throws RepositoryException {
        Session session = this.getSession(request, repositoryName, workspaceName);
        Item item = this.itemAtPath(path, session);
        return this.createRestItem(request, depth, session, item);
    }

    @Override
    public RestItem addItem(Request request, String repositoryName, String workspaceName, String path, String requestBody) throws RepositoryException {
        RestItem restItem;
        if (!this.__MaddItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_addItem(request, repositoryName, workspaceName, path, requestBody);
        }
        try {
            this.__IM.onEntry((Object)this, "addItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName, path, requestBody});
            restItem = this.__M_addItem(request, repositoryName, workspaceName, path, requestBody);
            this.__IM.onExit((Object)this, "addItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)restItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return restItem;
    }

    private RestItem __M_addItem(Request request, String repositoryName, String workspaceName, String path, String requestBody) throws RepositoryException {
        ObjectNode requestBodyJSON = this.stringToJSONObject(requestBody);
        String parentAbsPath = this.parentPath(path);
        String newNodeName = this.newNodeName(path);
        Session session = this.getSession(request, repositoryName, workspaceName);
        Node parentNode = (Node)session.getItem(parentAbsPath);
        Node newNode = this.addNode(parentNode, newNodeName, (JsonNode)requestBodyJSON);
        session.save();
        RestItem restNewNode = this.createRestItem(request, 0, session, (Item)newNode);
        return restNewNode;
    }

    @Override
    protected Json getJson() {
        Json json;
        if (!this.__MgetJson) {
            return this.__M_getJson();
        }
        try {
            this.__IM.onEntry((Object)this, "getJson", new Object[0]);
            json = this.__M_getJson();
            this.__IM.onExit((Object)this, "getJson", (Object)json);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJson", throwable);
            throw throwable;
        }
        return json;
    }

    private Json __M_getJson() {
        return this.__getjson();
    }

    @Override
    protected JsonNode getProperties(JsonNode jsonNode) {
        JsonNode jsonNode2;
        if (!this.__MgetProperties$com_fasterxml_jackson_databind_JsonNode) {
            return this.__M_getProperties(jsonNode);
        }
        try {
            this.__IM.onEntry((Object)this, "getProperties$com_fasterxml_jackson_databind_JsonNode", new Object[]{jsonNode});
            jsonNode2 = this.__M_getProperties(jsonNode);
            this.__IM.onExit((Object)this, "getProperties$com_fasterxml_jackson_databind_JsonNode", (Object)jsonNode2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProperties$com_fasterxml_jackson_databind_JsonNode", throwable);
            throw throwable;
        }
        return jsonNode2;
    }

    private JsonNode __M_getProperties(JsonNode jsonNode) {
        ObjectNode properties = this.__getjson().newObject();
        Iterator keysIterator = jsonNode.fields();
        while (keysIterator.hasNext()) {
            String key = keysIterator.next().toString();
            if ("children".equalsIgnoreCase(key)) continue;
            properties.put(key, jsonNode.get(key));
        }
        return properties;
    }

    private String newNodeName(String path) {
        String string;
        if (!this.__MnewNodeName$java_lang_String) {
            return this.__M_newNodeName(path);
        }
        try {
            this.__IM.onEntry((Object)this, "newNodeName$java_lang_String", new Object[]{path});
            string = this.__M_newNodeName(path);
            this.__IM.onExit((Object)this, "newNodeName$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "newNodeName$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_newNodeName(String path) {
        int lastSlashInd = path.lastIndexOf(47);
        String name = lastSlashInd == -1 ? path : path.substring(lastSlashInd + 1);
        name = name.replaceAll("\\[\\d+\\]$", "");
        return name;
    }

    @Override
    public RestItem updateItem(Request request, String rawRepositoryName, String rawWorkspaceName, String path, String requestContent) throws RepositoryException {
        RestItem restItem;
        if (!this.__MupdateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_updateItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "updateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, rawRepositoryName, rawWorkspaceName, path, requestContent});
            restItem = this.__M_updateItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
            this.__IM.onExit((Object)this, "updateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)restItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return restItem;
    }

    private RestItem __M_updateItem(Request request, String rawRepositoryName, String rawWorkspaceName, String path, String requestContent) throws RepositoryException {
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Item item = this.itemAtPath(path, session);
        item = this.updateItem(item, (JsonNode)this.stringToJSONObject(requestContent));
        session.save();
        return this.createRestItem(request, 0, session, item);
    }

    private ObjectNode stringToJSONObject(String requestBody) {
        ObjectNode objectNode;
        if (!this.__MstringToJSONObject$java_lang_String) {
            return this.__M_stringToJSONObject(requestBody);
        }
        try {
            this.__IM.onEntry((Object)this, "stringToJSONObject$java_lang_String", new Object[]{requestBody});
            objectNode = this.__M_stringToJSONObject(requestBody);
            this.__IM.onExit((Object)this, "stringToJSONObject$java_lang_String", (Object)objectNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stringToJSONObject$java_lang_String", throwable);
            throw throwable;
        }
        return objectNode;
    }

    private ObjectNode __M_stringToJSONObject(String requestBody) {
        return StringUtil.isBlank((String)requestBody) ? this.__getjson().newObject() : (ObjectNode)this.__getjson().parse(requestBody);
    }

    private ArrayNode stringToJSONArray(String requestBody) {
        ArrayNode arrayNode;
        if (!this.__MstringToJSONArray$java_lang_String) {
            return this.__M_stringToJSONArray(requestBody);
        }
        try {
            this.__IM.onEntry((Object)this, "stringToJSONArray$java_lang_String", new Object[]{requestBody});
            arrayNode = this.__M_stringToJSONArray(requestBody);
            this.__IM.onExit((Object)this, "stringToJSONArray$java_lang_String", (Object)arrayNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stringToJSONArray$java_lang_String", throwable);
            throw throwable;
        }
        return arrayNode;
    }

    private ArrayNode __M_stringToJSONArray(String requestBody) {
        return StringUtil.isBlank((String)requestBody) ? this.__getjson().newArray() : (ArrayNode)this.__getjson().parse(requestBody);
    }

    @Override
    public void addItems(Request request, String repositoryName, String workspaceName, String requestContent) throws RepositoryException {
        if (!this.__MaddItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_addItems(request, repositoryName, workspaceName, requestContent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName, requestContent});
            this.__M_addItems(request, repositoryName, workspaceName, requestContent);
            this.__IM.onExit((Object)this, "addItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_addItems(Request request, String repositoryName, String workspaceName, String requestContent) throws RepositoryException {
        ObjectNode requestBody = this.stringToJSONObject(requestContent);
        if (requestBody.size() != 0) {
            Session session = this.getSession(request, repositoryName, workspaceName);
            TreeMap<String, JsonNode> nodesByPath = this.createNodesByPathMap((JsonNode)requestBody);
            this.addMultipleNodes(request, nodesByPath, session);
        }
    }

    @Override
    public void updateItems(Request request, String repositoryName, String workspaceName, String requestContent) throws RepositoryException {
        if (!this.__MupdateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_updateItems(request, repositoryName, workspaceName, requestContent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName, requestContent});
            this.__M_updateItems(request, repositoryName, workspaceName, requestContent);
            this.__IM.onExit((Object)this, "updateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_updateItems(Request request, String repositoryName, String workspaceName, String requestContent) throws RepositoryException {
        ObjectNode requestBody = this.stringToJSONObject(requestContent);
        if (requestBody.size() != 0) {
            Session session = this.getSession(request, repositoryName, workspaceName);
            TreeMap<String, JsonNode> nodesByPath = this.createNodesByPathMap((JsonNode)requestBody);
            this.updateMultipleNodes(request, session, nodesByPath);
        }
    }

    @Override
    public void deleteItems(Request request, String repositoryName, String workspaceName, String requestContent) throws RepositoryException {
        if (!this.__MdeleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_deleteItems(request, repositoryName, workspaceName, requestContent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName, requestContent});
            this.__M_deleteItems(request, repositoryName, workspaceName, requestContent);
            this.__IM.onExit((Object)this, "deleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_deleteItems(Request request, String repositoryName, String workspaceName, String requestContent) throws RepositoryException {
        ArrayNode requestArray = this.stringToJSONArray(requestContent);
        if (requestArray.size() == 0) {
            return;
        }
        Session session = this.getSession(request, repositoryName, workspaceName);
        TreeSet<String> pathsInOrder = new TreeSet<String>();
        for (int i = 0; i < requestArray.size(); ++i) {
            pathsInOrder.add(this.absPath(requestArray.get(i).toString()));
        }
        ArrayList pathsInOrderList = new ArrayList(pathsInOrder);
        Collections.reverse(pathsInOrderList);
        for (String path : pathsInOrderList) {
            this.doDelete(path, session);
        }
        session.save();
    }

    private List<RestItem> updateMultipleNodes(Request request, Session session, TreeMap<String, JsonNode> nodesByPath) throws RepositoryException {
        List<RestItem> list;
        if (!this.__MupdateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap) {
            return this.__M_updateMultipleNodes(request, session, nodesByPath);
        }
        try {
            this.__IM.onEntry((Object)this, "updateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap", new Object[]{request, session, nodesByPath});
            list = this.__M_updateMultipleNodes(request, session, nodesByPath);
            this.__IM.onExit((Object)this, "updateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap", throwable);
            throw throwable;
        }
        return list;
    }

    private List<RestItem> __M_updateMultipleNodes(Request request, Session session, TreeMap<String, JsonNode> nodesByPath) throws RepositoryException {
        ArrayList<RestItem> result = new ArrayList<RestItem>();
        for (Map.Entry<String, JsonNode> nodePath : nodesByPath.entrySet()) {
            Item item = session.getItem(nodePath.getKey());
            item = this.updateItem(item, nodePath.getValue());
            result.add(this.createRestItem(request, 0, session, item));
        }
        session.save();
        return result;
    }

    private TreeMap<String, JsonNode> createNodesByPathMap(JsonNode requestBodyJSON) {
        TreeMap<String, JsonNode> treeMap;
        if (!this.__McreateNodesByPathMap$com_fasterxml_jackson_databind_JsonNode) {
            return this.__M_createNodesByPathMap(requestBodyJSON);
        }
        try {
            this.__IM.onEntry((Object)this, "createNodesByPathMap$com_fasterxml_jackson_databind_JsonNode", new Object[]{requestBodyJSON});
            treeMap = this.__M_createNodesByPathMap(requestBodyJSON);
            this.__IM.onExit((Object)this, "createNodesByPathMap$com_fasterxml_jackson_databind_JsonNode", treeMap);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createNodesByPathMap$com_fasterxml_jackson_databind_JsonNode", throwable);
            throw throwable;
        }
        return treeMap;
    }

    private TreeMap<String, JsonNode> __M_createNodesByPathMap(JsonNode requestBodyJSON) {
        TreeMap<String, JsonNode> nodesByPath = new TreeMap<String, JsonNode>();
        Iterator iterator = requestBodyJSON.fields();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String nodePath = this.absPath(key);
            JsonNode nodeJSON = requestBodyJSON.get(key);
            nodesByPath.put(nodePath, nodeJSON);
        }
        return nodesByPath;
    }

    private void addMultipleNodes(Request request, TreeMap<String, JsonNode> nodesByPath, Session session) throws RepositoryException {
        if (!this.__MaddMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session) {
            this.__M_addMultipleNodes(request, nodesByPath, session);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session", new Object[]{request, nodesByPath, session});
            this.__M_addMultipleNodes(request, nodesByPath, session);
            this.__IM.onExit((Object)this, "addMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session", throwable);
            throw throwable;
        }
    }

    private void __M_addMultipleNodes(Request request, TreeMap<String, JsonNode> nodesByPath, Session session) throws RepositoryException {
        ArrayList<RestItem> result = new ArrayList<RestItem>();
        for (Map.Entry<String, JsonNode> nodePath : nodesByPath.entrySet()) {
            String parentAbsPath = this.parentPath(nodePath.getKey());
            String newNodeName = this.newNodeName(nodePath.getKey());
            Node parentNode = (Node)session.getItem(parentAbsPath);
            Node newNode = this.addNode(parentNode, newNodeName, nodePath.getValue());
            RestItem restNewNode = this.createRestItem(request, 0, session, (Item)newNode);
            result.add(restNewNode);
        }
        session.save();
    }

    @Override
    protected RepositoryManager getRepositoryManager() {
        RepositoryManager repositoryManager;
        if (!this.__MgetRepositoryManager) {
            return this.__M_getRepositoryManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryManager", new Object[0]);
            repositoryManager = this.__M_getRepositoryManager();
            this.__IM.onExit((Object)this, "getRepositoryManager", (Object)repositoryManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryManager", throwable);
            throw throwable;
        }
        return repositoryManager;
    }

    private RepositoryManager __M_getRepositoryManager() {
        return this.__getrepositoryManager();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("json")) {
                this.__Fjson = true;
            }
            if (set.contains("repositoryManager")) {
                this.__FrepositoryManager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("item$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int")) {
                this.__Mitem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$int = true;
            }
            if (set.contains("addItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getJson")) {
                this.__MgetJson = true;
            }
            if (set.contains("getProperties$com_fasterxml_jackson_databind_JsonNode")) {
                this.__MgetProperties$com_fasterxml_jackson_databind_JsonNode = true;
            }
            if (set.contains("newNodeName$java_lang_String")) {
                this.__MnewNodeName$java_lang_String = true;
            }
            if (set.contains("updateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MupdateItem$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("stringToJSONObject$java_lang_String")) {
                this.__MstringToJSONObject$java_lang_String = true;
            }
            if (set.contains("stringToJSONArray$java_lang_String")) {
                this.__MstringToJSONArray$java_lang_String = true;
            }
            if (set.contains("addItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("updateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MupdateItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("deleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MdeleteItems$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("updateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap")) {
                this.__MupdateMultipleNodes$org_wisdom_api_http_Request$javax_jcr_Session$java_util_TreeMap = true;
            }
            if (set.contains("createNodesByPathMap$com_fasterxml_jackson_databind_JsonNode")) {
                this.__McreateNodesByPathMap$com_fasterxml_jackson_databind_JsonNode = true;
            }
            if (set.contains("addMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session")) {
                this.__MaddMultipleNodes$org_wisdom_api_http_Request$java_util_TreeMap$javax_jcr_Session = true;
            }
            if (set.contains("getRepositoryManager")) {
                this.__MgetRepositoryManager = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

