/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.StringWriter;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.wisdom.api.content.Json;

public final class RestException
implements JSONAble {
    private final String message;
    private final String stackTrace;

    public RestException(String message) {
        this.message = message;
        this.stackTrace = null;
    }

    public RestException(Throwable t) {
        this.message = t.getMessage();
        StringWriter stringWriter = new StringWriter();
        for (StackTraceElement trace : t.getStackTrace()) {
            stringWriter.append(trace.toString());
        }
        this.stackTrace = stringWriter.toString();
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode object = json.newObject();
        object.put("exception", this.message);
        if (this.stackTrace != null) {
            object.put("stacktrace", this.stackTrace);
        }
        return object;
    }
}

