/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.wisdom.api.content.Json;

public final class RestProperty
extends RestItem {
    private final List<String> values;
    private final boolean multiValued;

    public RestProperty(String name, String url, String parentUrl, List<String> values, boolean multiValued) {
        super(name, url, parentUrl);
        this.values = values != null ? values : Collections.emptyList();
        this.multiValued = multiValued;
    }

    List<String> getValues() {
        return this.values;
    }

    String getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    boolean isMultiValue() {
        return this.multiValued;
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode object = json.newObject();
        if (this.isMultiValue()) {
            ArrayNode valuesNode = object.putArray("values");
            for (String value : this.values) {
                valuesNode.add(value);
            }
        } else if (this.getValue() != null) {
            object.put(this.name, this.getValue());
        }
        object.put("self", this.url);
        object.put("up", this.parentUrl);
        return object;
    }
}

