/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.modeshape.web.jcr.rest.model.Stringable;
import org.wisdom.api.content.Json;

public final class RestQueryPlanResult
implements JSONAble,
Stringable {
    private final String plan;
    private final String language;
    private final String statement;
    private final String aqm;

    public RestQueryPlanResult(String plan, String statement, String language, String aqm) {
        this.plan = plan;
        this.statement = statement;
        this.language = language;
        this.aqm = aqm;
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode result = json.newObject();
        result.put("statement", this.statement);
        result.put("language", this.language);
        result.put("abstractQueryModel", this.aqm);
        String[] planParts = this.plan.split("\\n");
        ArrayNode planArray = result.putArray("queryPlan");
        for (String part : planParts) {
            planArray.add(part);
        }
        return result;
    }

    @Override
    public String asString() {
        return this.plan;
    }
}

